/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.checks.FunMatcherKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.api.reporting.Message;
import org.sonarsource.kotlin.checks.UselessNullCheckCheck;
import org.sonarsource.kotlin.checks.UselessNullCheckCheckKt;

@Rule(key="S6619")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J9\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0002\b\u000eH\u0002J9\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0002\b\u000eH\u0002JA\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00040\f\u00a2\u0006\u0002\b\u000eH\u0002J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006H\u0016J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010 \u001a\u0004\u0018\u00010\b*\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0002\u00a8\u0006#"}, d2={"Lorg/sonarsource/kotlin/checks/UselessNullCheckCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "handleNonNullCheck", "", "kfc", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "issueLocation", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "nullCheckTypeForMessage", "Lkotlin/Function1;", "Lorg/sonarsource/kotlin/api/reporting/Message;", "Lkotlin/ExtensionFunctionType;", "handleNullCheck", "raiseIssueIfUselessCheck", "comparesToNull", "", "visitBinaryExpression", "binaryExpression", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "kotlinFileContext", "visitCallExpression", "callExpression", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitSafeQualifiedExpression", "safeDotExpression", "Lorg/jetbrains/kotlin/psi/KtSafeQualifiedExpression;", "visitUnaryExpression", "unaryExpression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "operandComparedToNull", "bc", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "sonar-kotlin-checks"})
public final class UselessNullCheckCheck
extends AbstractCheck {
    @Override
    public void visitBinaryExpression(@NotNull KtBinaryExpression binaryExpression, @NotNull KotlinFileContext kotlinFileContext) {
        Intrinsics.checkNotNullParameter(binaryExpression, "binaryExpression");
        Intrinsics.checkNotNullParameter(kotlinFileContext, "kotlinFileContext");
        BindingContext bc = kotlinFileContext.getBindingContext();
        IElementType iElementType = binaryExpression.getOperationToken();
        if (Intrinsics.areEqual(iElementType, KtTokens.EQEQ)) {
            KtExpression ktExpression = this.operandComparedToNull(binaryExpression, bc);
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                this.handleNullCheck(kotlinFileContext, it, binaryExpression, visitBinaryExpression.1.1.INSTANCE);
            }
        } else if (Intrinsics.areEqual(iElementType, KtTokens.EXCLEQ)) {
            KtExpression ktExpression = this.operandComparedToNull(binaryExpression, bc);
            if (ktExpression != null) {
                KtExpression it = ktExpression;
                boolean bl = false;
                this.handleNonNullCheck(kotlinFileContext, it, binaryExpression, visitBinaryExpression.2.1.INSTANCE);
            }
        } else if (Intrinsics.areEqual(iElementType, KtTokens.ELVIS)) {
            KtExpression ktExpression = binaryExpression.getLeft();
            Intrinsics.checkNotNull(ktExpression);
            KtOperationReferenceExpression ktOperationReferenceExpression = binaryExpression.getOperationReference();
            Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
            this.handleNonNullCheck(kotlinFileContext, ktExpression, ktOperationReferenceExpression, visitBinaryExpression.3.INSTANCE);
        }
    }

    @Override
    public void visitSafeQualifiedExpression(@NotNull KtSafeQualifiedExpression safeDotExpression, @NotNull KotlinFileContext kfc) {
        Intrinsics.checkNotNullParameter(safeDotExpression, "safeDotExpression");
        Intrinsics.checkNotNullParameter(kfc, "kfc");
        KtExpression ktExpression = safeDotExpression.getReceiverExpression();
        PsiElement psiElement = safeDotExpression.getOperationTokenNode().getPsi();
        Intrinsics.checkNotNullExpressionValue(psiElement, "getPsi(...)");
        this.handleNonNullCheck(kfc, ktExpression, psiElement, visitSafeQualifiedExpression.1.INSTANCE);
    }

    @Override
    public void visitUnaryExpression(@NotNull KtUnaryExpression unaryExpression, @NotNull KotlinFileContext kfc) {
        Intrinsics.checkNotNullParameter(unaryExpression, "unaryExpression");
        Intrinsics.checkNotNullParameter(kfc, "kfc");
        if (Intrinsics.areEqual(unaryExpression.getOperationToken(), KtTokens.EXCLEXCL)) {
            KtExpression ktExpression = unaryExpression.getBaseExpression();
            Intrinsics.checkNotNull(ktExpression);
            KtSimpleNameExpression ktSimpleNameExpression = unaryExpression.getOperationReference();
            Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "getOperationReference(...)");
            this.handleNonNullCheck(kfc, ktExpression, ktSimpleNameExpression, visitUnaryExpression.1.INSTANCE);
        }
    }

    @Override
    public void visitCallExpression(@NotNull KtCallExpression callExpression, @NotNull KotlinFileContext kfc) {
        Intrinsics.checkNotNullParameter(callExpression, "callExpression");
        Intrinsics.checkNotNullParameter(kfc, "kfc");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callExpression, kfc.getBindingContext());
        if (FunMatcherKt.matches(resolvedCall2, UselessNullCheckCheckKt.access$getNON_NULL_CHECK_FUNS$p())) {
            KtExpression ktExpression = CollectionsKt.first(ResolvedCallUtilKt.getArgumentByParameterIndex(callExpression, 0, kfc.getBindingContext())).getArgumentExpression();
            Intrinsics.checkNotNull(ktExpression);
            this.handleNonNullCheck(kfc, ktExpression, callExpression, (Function1<? super Message, Unit>)new Function1<Message, Unit>(resolvedCall2){
                final /* synthetic */ ResolvedCall<? extends CallableDescriptor> $resolvedCall;
                {
                    this.$resolvedCall = $resolvedCall;
                    super(1);
                }

                public final void invoke(@NotNull Message $this$handleNonNullCheck) {
                    Intrinsics.checkNotNullParameter($this$handleNonNullCheck, "$this$handleNonNullCheck");
                    $this$handleNonNullCheck.unaryPlus("non-null check ");
                    ResolvedCall<? extends CallableDescriptor> resolvedCall2 = this.$resolvedCall;
                    Intrinsics.checkNotNull(resolvedCall2);
                    String string2 = resolvedCall2.getResultingDescriptor().getName().asString();
                    Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
                    $this$handleNonNullCheck.code(string2);
                }
            });
        }
    }

    private final KtExpression operandComparedToNull(KtBinaryExpression $this$operandComparedToNull, BindingContext bc) {
        KtExpression ktExpression = $this$operandComparedToNull.getLeft();
        if (ktExpression == null || (ktExpression = ApiExtensionsKt.predictRuntimeValueExpression$default(ktExpression, bc, null, 2, null)) == null) {
            return null;
        }
        KtExpression leftResolved = ktExpression;
        KtExpression ktExpression2 = $this$operandComparedToNull.getRight();
        if (ktExpression2 == null || (ktExpression2 = ApiExtensionsKt.predictRuntimeValueExpression$default(ktExpression2, bc, null, 2, null)) == null) {
            return null;
        }
        KtExpression rightResolved = ktExpression2;
        return PsiUtilsKt.isNull(leftResolved) ? $this$operandComparedToNull.getRight() : (PsiUtilsKt.isNull(rightResolved) ? $this$operandComparedToNull.getLeft() : null);
    }

    private final void handleNullCheck(KotlinFileContext kfc, KtExpression expression2, PsiElement issueLocation, Function1<? super Message, Unit> nullCheckTypeForMessage) {
        this.raiseIssueIfUselessCheck(kfc, expression2, issueLocation, true, nullCheckTypeForMessage);
    }

    private final void handleNonNullCheck(KotlinFileContext kfc, KtExpression expression2, PsiElement issueLocation, Function1<? super Message, Unit> nullCheckTypeForMessage) {
        this.raiseIssueIfUselessCheck(kfc, expression2, issueLocation, false, nullCheckTypeForMessage);
    }

    private final void raiseIssueIfUselessCheck(KotlinFileContext kfc, KtExpression expression2, PsiElement issueLocation, boolean comparesToNull, Function1<? super Message, Unit> nullCheckTypeForMessage) {
        String string2;
        if (UselessNullCheckCheckKt.access$mayBeAffectedByErrorInSemantics(kfc)) {
            return;
        }
        KtExpression resolvedExpression = ApiExtensionsKt.predictRuntimeValueExpression$default(expression2, kfc.getBindingContext(), null, 2, null);
        if (PsiUtilsKt.isNull(resolvedExpression)) {
            string2 = comparesToNull ? "succeeds" : "fails";
        } else if (UselessNullCheckCheckKt.access$isNotNullable(expression2, kfc.getBindingContext())) {
            string2 = comparesToNull ? "fails" : "succeeds";
        } else {
            return;
        }
        String result2 = string2;
        AbstractCheck.reportIssue$default((AbstractCheck)this, kfc, issueLocation, null, null, new Function1<Message, Unit>(nullCheckTypeForMessage, result2){
            final /* synthetic */ Function1<Message, Unit> $nullCheckTypeForMessage;
            final /* synthetic */ String $result;
            {
                this.$nullCheckTypeForMessage = $nullCheckTypeForMessage;
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull Message $this$reportIssue) {
                Intrinsics.checkNotNullParameter($this$reportIssue, "$this$reportIssue");
                $this$reportIssue.unaryPlus("Remove this useless ");
                this.$nullCheckTypeForMessage.invoke($this$reportIssue);
                $this$reportIssue.unaryPlus(", it always " + this.$result + ".");
            }
        }, 6, null);
    }
}

