/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.metrics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.psi.PsiComment;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.checks.CognitiveComplexity;
import org.sonarsource.kotlin.metrics.CyclomaticComplexityVisitor;
import org.sonarsource.kotlin.metrics.KtMetricVisitor;
import org.sonarsource.kotlin.metrics.KtMetricVisitor$visitKtFile$;
import org.sonarsource.kotlin.metrics.MetricVisitorKt;
import org.sonarsource.kotlin.metrics.StatementsVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010+\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020-H\u0016J\u0010\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u000200H\u0016R\u001e\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R*\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R*\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR*\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00102\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000bR*\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\b2\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000bR\u001e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0007R\u001e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0007R\u001e\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0007\u00a8\u00061"}, d2={"Lorg/sonarsource/kotlin/metrics/KtMetricVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "()V", "<set-?>", "", "cognitiveComplexity", "getCognitiveComplexity", "()I", "", "commentLines", "getCommentLines", "()Ljava/util/Set;", "complexity", "getComplexity", "executableLines", "getExecutableLines", "", "linesOfCode", "getLinesOfCode", "nosonarLines", "getNosonarLines", "numberOfClasses", "getNumberOfClasses", "numberOfFunctions", "getNumberOfFunctions", "statements", "getStatements", "addExecutableLines", "", "elements", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "document", "Lorg/jetbrains/kotlin/com/intellij/openapi/editor/Document;", "visitBlockExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitComment", "comment", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiComment;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "sonar-kotlin-metrics"})
@SourceDebugExtension(value={"SMAP\nMetricVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MetricVisitor.kt\norg/sonarsource/kotlin/metrics/KtMetricVisitor\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,197:1\n3630#2,10:198\n1855#3,2:208\n1855#3,2:229\n286#4,15:210\n228#4,2:225\n240#4:227\n305#4:228\n1313#5,2:231\n*S KotlinDebug\n*F\n+ 1 MetricVisitor.kt\norg/sonarsource/kotlin/metrics/KtMetricVisitor\n*L\n132#1:198,10\n132#1:208,2\n135#1:229,2\n135#1:210,15\n135#1:225,2\n135#1:227\n135#1:228\n168#1:231,2\n*E\n"})
final class KtMetricVisitor
extends KtTreeVisitorVoid {
    @NotNull
    private Set<Integer> linesOfCode = new LinkedHashSet();
    @NotNull
    private Set<Integer> commentLines = new LinkedHashSet();
    @NotNull
    private Set<Integer> nosonarLines = new LinkedHashSet();
    @NotNull
    private Set<Integer> executableLines = new LinkedHashSet();
    private int numberOfFunctions;
    private int numberOfClasses;
    private int complexity;
    private int statements;
    private int cognitiveComplexity;

    @NotNull
    public final Set<Integer> getLinesOfCode() {
        return this.linesOfCode;
    }

    @NotNull
    public final Set<Integer> getCommentLines() {
        return this.commentLines;
    }

    @NotNull
    public final Set<Integer> getNosonarLines() {
        return this.nosonarLines;
    }

    @NotNull
    public final Set<Integer> getExecutableLines() {
        return this.executableLines;
    }

    public final int getNumberOfFunctions() {
        return this.numberOfFunctions;
    }

    public final int getNumberOfClasses() {
        return this.numberOfClasses;
    }

    public final int getComplexity() {
        return this.complexity;
    }

    public final int getStatements() {
        return this.statements;
    }

    public final int getCognitiveComplexity() {
        return this.cognitiveComplexity;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitKtFile(@NotNull KtFile file2) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Intrinsics.checkNotNullParameter(file2, "file");
        this.linesOfCode = ApiExtensionsKt.linesOfCode(file2);
        CyclomaticComplexityVisitor complexityVisitor = new CyclomaticComplexityVisitor();
        file2.accept(complexityVisitor);
        this.complexity = complexityVisitor.complexityTrees().size();
        this.cognitiveComplexity = new CognitiveComplexity(file2).value();
        StatementsVisitor statementsVisitor = new StatementsVisitor();
        file2.accept(statementsVisitor);
        this.statements = statementsVisitor.getStatements();
        PsiElement[] psiElementArray = file2.getChildren();
        Intrinsics.checkNotNullExpressionValue(psiElementArray, "getChildren(...)");
        Object[] objectArray = psiElementArray;
        boolean $i$f$dropWhile = false;
        boolean yielding$iv = false;
        ArrayList<Object> list$iv = new ArrayList<Object>();
        for (Object item$iv : objectArray) {
            if (yielding$iv) {
                list$iv.add(item$iv);
                continue;
            }
            PsiElement it = (PsiElement)item$iv;
            boolean bl2 = false;
            if (it instanceof PsiComment || it instanceof PsiWhiteSpace) continue;
            list$iv.add(item$iv);
            yielding$iv = true;
        }
        Iterable iterable = list$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : iterable) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            it.accept(this);
        }
        PsiFile psiFile = file2.getContainingFile();
        Intrinsics.checkNotNullExpressionValue(psiFile, "getContainingFile(...)");
        PsiElement psiElement = psiFile;
        Function1 predicate$iv = visitKtFile$$inlined$collectDescendantsOfType$default$1.INSTANCE;
        boolean $i$f$collectDescendantsOfType = false;
        PsiElement $this$collectDescendantsOfType$iv$iv = psiElement;
        boolean $i$f$collectDescendantsOfType2 = false;
        PsiElement bl = $this$collectDescendantsOfType$iv$iv;
        Collection to$iv$iv$iv = new ArrayList();
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void bl2 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = new Function1<KDoc, Unit>(predicate$iv, to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
                super(1);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(@NotNull PsiElement it) {
                Intrinsics.checkNotNullParameter(it, "it");
                if (((Boolean)this.$predicate.invoke(it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept(new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(@NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KDoc) {
                    this.$action.invoke(element);
                }
            }
        });
        Iterable iterable2 = (List)to$iv$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : iterable2) {
            KDoc it = (KDoc)element$iv;
            boolean bl3 = false;
            MetricVisitorKt.access$addCommentMetrics(it, this.commentLines, this.nosonarLines);
        }
    }

    @Override
    public void visitComment(@NotNull PsiComment comment) {
        Intrinsics.checkNotNullParameter(comment, "comment");
        MetricVisitorKt.access$addCommentMetrics(comment, this.commentLines, this.nosonarLines);
    }

    @Override
    public void visitNamedFunction(@NotNull KtNamedFunction function2) {
        Intrinsics.checkNotNullParameter(function2, "function");
        if (function2.hasBody() && function2.getName() != null) {
            int n = this.numberOfFunctions;
            this.numberOfFunctions = n + 1;
        }
        super.visitNamedFunction(function2);
    }

    @Override
    public void visitClass(@NotNull KtClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        int n = this.numberOfClasses;
        this.numberOfClasses = n + 1;
        super.visitClass(klass);
    }

    @Override
    public void visitBlockExpression(@NotNull KtBlockExpression expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        List<KtExpression> list2 = expression2.getStatements();
        Intrinsics.checkNotNullExpressionValue(list2, "getStatements(...)");
        Document document = expression2.getContainingKtFile().getViewProvider().getDocument();
        Intrinsics.checkNotNull(document);
        this.addExecutableLines(list2, document);
        super.visitBlockExpression(expression2);
    }

    private final void addExecutableLines(List<? extends KtElement> elements, Document document) {
        Sequence $this$forEach$iv = SequencesKt.filterNot(CollectionsKt.asSequence((Iterable)elements), addExecutableLines.1.INSTANCE);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            KtElement it = (KtElement)element$iv;
            boolean bl = false;
            this.executableLines.add(document.getLineNumber(it.getTextRange().getStartOffset()) + 1);
        }
    }
}

