/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.model.EPasswordType;
import com.teamscale.core.analysis.configuration.model.IConnectorEnum;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.index.shared.EVersionControlSystemType;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@ExportToTypeScript
@IndexValueClass(containedInBackup=true)
public enum ERepositoryConnector implements IConnectorEnum<ERepositoryConnector>
{
    TFS("Azure DevOps TFVC (TFS)", "images/connectors/tfvc.png", "https://docs.microsoft.com/en-us/azure/devops/repos/tfvc/?toc=%2Fazure%2Fdevops%2Frepos%2Ftfvc%2Ftoc.json&bc=%2Fazure%2Fdevops%2Frepos%2Ftfvc%2Fbreadcrumb%2Ftoc.json&view=azure-devops", "Reads files from Azure DevOps stored in a Team Foundation Version Control repository (formerly known as TFS).", true, EPasswordType.ACCESS_TOKEN),
    FILE_SYSTEM("File System", "images/connectors/file.png", "", "Reads files from a directory in the local file system.", false),
    GIT(EVersionControlSystemType.GIT.getLabel(), "images/connectors/git.svg", "http://git-scm.com/", "Reads files from a Git repository. Local repositories as well as remote repositories using HTTP(S) and SSH are supported."),
    GITHUB("GitHub", "images/connectors/github.svg", "https://github.com/", "Reads code from a GitHub project and annotates pull requests.", true, EPasswordType.PASSWORD_OR_ACCESS_TOKEN),
    GERRIT("Gerrit", "images/connectors/gerrit.svg", "https://www.gerritcodereview.com/", "Reads data from a Gerrit repository and votes on reviews."),
    BITBUCKET("Bitbucket Cloud", "images/connectors/bitbucket.svg", "https://www.bitbucket.org/", "Reads data from a Bitbucket cloud repository and annotates pull requests. Installing Teamscale's Bitbucket App is a prerequisite for this connector.", true, EPasswordType.PASSWORD_OR_ACCESS_TOKEN, true),
    BITBUCKET_SERVER("Bitbucket Data Center (On-Premise)", "images/connectors/bitbucket.svg", "https://www.atlassian.com/software/bitbucket/enterprise/data-center", "Reads data from a Bitbucket Data Center (on-premise) repository and annotates pull requests.", true, EPasswordType.PASSWORD_OR_ACCESS_TOKEN),
    GITLAB("GitLab", "images/connectors/gitlab.svg", "https://about.gitlab.com/", "Reads data from a GitLab repository and annotates merge requests.", true, EPasswordType.ACCESS_TOKEN),
    SVN(EVersionControlSystemType.SVN.getLabel(), "images/connectors/svn.svg", "http://subversion.apache.org/", "Reads files from a Subversion (SVN) repository. Supports file, HTTP(S), SVN, and SSH+SVN protocols."),
    MULTI_VERSION_FILE_SYSTEM("Multi-Version File System", "images/connectors/file.png", "", "Reads commits in a Teamscale-defined format from a directory in the local file system.", "Reads files from a directory in the local file system. Folder names must be numeric and are interpreted as timestamps (milliseconds since January 1, 1970 00:00:00.000 GMT).\nThe folder name can specify a branch name, separated by underscore or colon (default is the default branch name).\nThe folder name can specify parent commits, separated by underscore.\n\nThe following example shows two commits on \"master\" and one on \"branch\" that forks from and is merged back in master.\n```\nmaster_1\nbranch_2_master_1\nmaster_3_branch_2_master_1\n```\nSee the Javadoc of MultiVersionFileSystemCommit for further details.\n\nConsider disabling ***Start revision*** and ***branch-specific start dates***.\n", false, EPasswordType.PASSWORD, false),
    ARTIFACTORY("Artifactory", "images/connectors/artifactory.png", "https://www.jfrog.com/artifactory/", "Reads code and external reports in zip, tar.gz, and tar.bz2 archives from a Artifactory repository."),
    S3("S3", "images/connectors/s3.png", "https://aws.amazon.com/s3/", "Reads code and external reports in zip, tar.gz, and tar.bz2 archives from an S3 bucket.", true, EPasswordType.SECRET_KEY),
    AZURE_DEVOPS_GIT("Azure DevOps Git", "images/connectors/azure_devops.png", "https://azure.microsoft.com/en-us/services/devops/", "Reads Git repository data from Azure DevOps Services or Azure DevOps Server and annotates pull requests.", true, EPasswordType.PASSWORD_OR_ACCESS_TOKEN),
    SCM_MANAGER("SCM-Manager", "images/connectors/scm_manager.png", "https://www.scm-manager.org/", "Reads Git repository data from SCM-Manager and annotates pull requests.", true, EPasswordType.PASSWORD_OR_ACCESS_TOKEN),
    ABAP_GIT("ABAP", "images/connectors/sap.svg", "https://www.sap.com/", "Reads ABAP code, Code Inspector findings, and coverage data from a configured SAP connection."),
    ARTIFICIAL_MERGE_REQUEST("Artificial Merge Request Connector", "images/connectors/git.svg", "https://cqse.eu/", "For testing: Reads files from a Git repository and creates artificial merge requests targeting the default branch for each branch given via the option \"Branches for artificial merge requests\". Local repositories as well as remote repositories using HTTP(S) and SSH are supported."),
    GITEA("Gitea", "images/connectors/gitea.svg", "https://about.gitea.com/", "Reads data from a Gitea repository and annotates pull requests.", true, EPasswordType.PASSWORD_OR_ACCESS_TOKEN);

    private static final EnumSet<ERepositoryConnector> GIT_BASED_CONNECTORS;
    private static final EnumSet<ERepositoryConnector> IGNORED_BY_PRE_COMMIT_3;
    private static final Map<String, ERepositoryConnector> REPOSITORY_CONNECTOR_BY_READABLE_NAME;
    private static final String READABLE_NAME_PROPERTY_NAME = "readableName";
    private static final String LOGO_URL_PROPERTY_NAME = "logoUrl";
    private static final String WEBSITE_URL_PROPERTY_NAME = "websiteUrl";
    private static final String DESCRIPTION_PROPERTY_NAME = "description";
    private static final String LONG_DESCRIPTION_PROPERTY_NAME = "longDescription";
    private static final String ACCOUNT_BASED_PROPERTY_NAME = "accountBased";
    private static final String PASSWORD_TYPE_PROPERTY_NAME = "passwordType";
    private static final String IS_BETA_PROPERTY_NAME = "isBeta";
    @JsonProperty(value="readableName")
    private final String readableName;
    @JsonProperty(value="logoUrl")
    private final String logoUrl;
    @JsonProperty(value="websiteUrl")
    private final String websiteUrl;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="longDescription")
    public final @Nullable String longDescription;
    @JsonProperty(value="accountBased")
    private final boolean accountBased;
    @JsonProperty(value="passwordType")
    private final EPasswordType passwordType;
    @JsonProperty(value="isBeta")
    private final boolean isBeta;

    private ERepositoryConnector(@JsonProperty(value="websiteUrl") String readableName, @JsonProperty(value="description") String logoUrl, @JsonProperty(value="longDescription") @Nullable String websiteUrl, @JsonProperty(value="accountBased") String description, @JsonProperty(value="passwordType") String longDescription, @JsonProperty(value="isBeta") boolean accountBased, EPasswordType passwordType, boolean isBeta) {
        this.readableName = readableName;
        this.logoUrl = logoUrl;
        this.websiteUrl = websiteUrl;
        this.description = description;
        this.longDescription = longDescription;
        this.accountBased = accountBased;
        this.passwordType = passwordType;
        this.isBeta = isBeta;
    }

    private ERepositoryConnector(String readableName, String logoUrl, String websiteUrl, String description, boolean accountBased, EPasswordType passwordType) {
        this(readableName, logoUrl, websiteUrl, description, accountBased, passwordType, false);
    }

    private ERepositoryConnector(String readableName, String logoUrl, String websiteUrl, String description, boolean accountBased, EPasswordType passwordType, boolean isBeta) {
        this(readableName, logoUrl, websiteUrl, description, null, accountBased, passwordType, isBeta);
    }

    private ERepositoryConnector(String readableName, String logoUrl, String websiteUrl, String description, boolean accountBased) {
        this(readableName, logoUrl, websiteUrl, description, accountBased, EPasswordType.PASSWORD);
    }

    private ERepositoryConnector(String readableName, String logoUrl, String websiteUrl, String description) {
        this(readableName, logoUrl, websiteUrl, description, true);
    }

    @Override
    public String getReadableName() {
        return this.readableName;
    }

    @Override
    public String getLogoUrl() {
        return this.logoUrl;
    }

    @Override
    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public @Nullable String getLongDescription() {
        return this.longDescription;
    }

    @Override
    public EPasswordType getPasswordType() {
        return this.passwordType;
    }

    @Override
    public Boolean isBeta() {
        return this.isBeta;
    }

    public static @Nullable ERepositoryConnector findByReadableName(String readableName) {
        return REPOSITORY_CONNECTOR_BY_READABLE_NAME.get(readableName);
    }

    public static UnmodifiableSet<String> getReadableNames() {
        return CollectionUtils.asUnmodifiable(REPOSITORY_CONNECTOR_BY_READABLE_NAME.keySet());
    }

    public static boolean isIgnoredByPreCommit3(ERepositoryConnector connectorType) {
        return IGNORED_BY_PRE_COMMIT_3.contains(connectorType);
    }

    public static boolean isGitBasedConnector(ERepositoryConnector connectorType) {
        return GIT_BASED_CONNECTORS.contains(connectorType);
    }

    static {
        GIT_BASED_CONNECTORS = EnumSet.of(GIT, new ERepositoryConnector[]{GITHUB, GERRIT, BITBUCKET, BITBUCKET_SERVER, GITLAB, AZURE_DEVOPS_GIT, SCM_MANAGER, ABAP_GIT, ARTIFICIAL_MERGE_REQUEST, GITEA});
        IGNORED_BY_PRE_COMMIT_3 = EnumSet.of(S3, ARTIFACTORY);
        REPOSITORY_CONNECTOR_BY_READABLE_NAME = new HashMap<String, ERepositoryConnector>(ERepositoryConnector.values().length);
        for (ERepositoryConnector repositoryConnector : ERepositoryConnector.values()) {
            REPOSITORY_CONNECTOR_BY_READABLE_NAME.put(repositoryConnector.getReadableName(), repositoryConnector);
        }
    }
}

