/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.analysis.configuration.model.option;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.js_export.ExportToTypeScript;

@ExportToTypeScript
public class EnumOptionDescriptor
extends ConfigOptionDescriptorBase {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="enumConstants")
    private List<Enum<?>> enumConstants;

    public EnumOptionDescriptor(ConfigExposed annotation, Field field) {
        super(annotation, field, field.getType().getSimpleName());
        CCSMAssert.isTrue((boolean)Enum.class.isAssignableFrom(field.getType()), (String)"This descriptor can only be used with enums");
        this.enumConstants = Arrays.asList((Enum[])field.getType().getEnumConstants());
    }

    @Override
    protected Object parseValue(String optionValue) {
        for (Enum<?> constant : this.enumConstants) {
            if (!constant.name().equalsIgnoreCase(optionValue)) continue;
            return constant;
        }
        throw new IllegalArgumentException("Unknown enum: " + optionValue);
    }
}

