/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.authenticate.crowd;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.authenticate.base.ServerDescriptionBase;
import com.teamscale.core.authenticate.crowd.CrowdSynchronizeTriggerAuto;
import com.teamscale.core.authenticate.crowd.CrowdUtils;
import com.teamscale.core.config.InstanceConfiguration;
import com.teamscale.core.index.IStorageInfo;
import com.teamscale.core.option.EOptionCategory;
import com.teamscale.core.option.EOptionType;
import com.teamscale.core.option.Option;
import com.teamscale.core.option.OptionFieldDescription;
import com.teamscale.core.option.PasswordOption;
import com.teamscale.core.option.ScheduleOption;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.js_export.ExportToTypeScript;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

@ExportToTypeScript
@Option(id="auth.crowd.server", name="Crowd Server", type=EOptionType.SERVER, multiOption=true, category=EOptionCategory.AUTH, orderingHint=300)
@IndexValueClass(containedInBackup=true)
public class CrowdServerDescription
extends ServerDescriptionBase {
    public static final String OPTION_ID = "auth.crowd.server";
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="url")
    @OptionFieldDescription(name="The URL under which the Crowd server is reachable")
    public String url;
    @JsonProperty(value="applicationName")
    @OptionFieldDescription(name="The Crowd application name")
    public String applicationName;
    @JsonProperty(value="applicationPassword")
    @PasswordOption
    @OptionFieldDescription(name="The Crowd application password")
    public String applicationPassword;
    @JsonProperty(value="updateSchedule")
    @OptionFieldDescription(name="Automatic server synchronization schedule")
    @ScheduleOption(triggerClass=CrowdSynchronizeTriggerAuto.class)
    public String updateSchedule = "";

    @Override
    public EAuthenticationTool getAuthenticationTool() {
        return EAuthenticationTool.CROWD;
    }

    @Override
    public boolean isEmpty() {
        return StringUtils.isEmpty((String)this.url);
    }

    @Override
    public String validate(IStorageInfo storageInfo, InstanceConfiguration instanceConfiguration) throws StorageException {
        String superError = super.validate(storageInfo, instanceConfiguration);
        if (superError != null) {
            return superError;
        }
        if (StringUtils.isEmpty((String)this.url)) {
            return "URL of the server missing";
        }
        if (StringUtils.isEmpty((String)this.applicationName)) {
            return "Application name missing!";
        }
        if (StringUtils.isEmpty((String)this.applicationPassword)) {
            return "Application password missing!";
        }
        return CrowdUtils.testConnection(this);
    }
}

