/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log.js;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.log.LogCount;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.ShortLogEntryBase;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class ShortJavaScriptErrorLog
extends ShortLogEntryBase {
    private static final String ERROR_MESSAGE_PROPERTY_NAME = "errorMessage";
    private static final String URL_PROPERTY_NAME = "url";
    private static final String USER_PROPERTY_NAME = "user";
    private static final String STACKTRACE_PROPERTY_NAME = "stacktrace";
    private static final String BROWSER_PROPERTY_NAME = "browser";
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="url")
    private final String url;
    @JsonProperty(value="user")
    private final String user;
    @JsonProperty(value="stacktrace")
    private final String stacktrace;
    @JsonProperty(value="browser")
    private final String browser;
    private static final long serialVersionUID = 1L;

    public ShortJavaScriptErrorLog(LogEntryIdentifier logEntryIdentifier, InternalProjectId projectId, String errorMessage, String url, String user, String browser) {
        super(logEntryIdentifier, LogCount.ofError(1), (IProjectId)projectId);
        this.errorMessage = errorMessage.split("\n")[0];
        this.stacktrace = errorMessage;
        this.url = url;
        this.user = user;
        this.browser = browser;
    }

    public ShortJavaScriptErrorLog(ShortJavaScriptErrorLog log, InternalProjectId newProject) {
        this(log.getId(), newProject, log.getErrorMessage(), log.getUrl(), log.getUser(), log.getBrowser());
    }

    public String getStacktrace() {
        return this.stacktrace;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getBrowser() {
        return this.browser;
    }

    @Override
    protected Stream<String> getFilterCriteria() {
        return Stream.concat(super.getFilterCriteria(), Stream.of(this.errorMessage, this.url, this.user, this.stacktrace, this.browser));
    }

    @Override
    protected void appendFields(StringBuilder builder) {
        super.appendFields(builder);
        builder.append("Project Name: ").append(this.getProjectId()).append("\n ");
        builder.append("User: ").append(this.user).append("\n ");
        builder.append("URL: ").append(this.url).append("\n ");
        builder.append("Stacktrace: \n").append(this.stacktrace).append("\n");
        builder.append("User Agent: \n").append(this.browser);
    }

    @Override
    protected void appendErrorStatistics(StringBuilder builder) {
    }
}

