/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.log.worker;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.log.LogCount;
import com.teamscale.core.log.LogEntryIdentifier;
import com.teamscale.core.log.worker.ShortWorkerLog;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class ShortCriticalEventWorkerLog
extends ShortWorkerLog {
    private static final long serialVersionUID = 1L;
    private static final String SCHEDULING_REASON_PROPERTY_NAME = "schedulingReason";
    private static final String ROLLBACK_ID_PROPERTY_NAME = "rollbackId";
    @JsonProperty(value="schedulingReason")
    private final String schedulingReason;
    @JsonProperty(value="rollbackId")
    private final @Nullable UUID rollbackId;

    public ShortCriticalEventWorkerLog(String workerId, InternalProjectId projectId, String triggerName, LogEntryIdentifier identifier, long finishTime, CommitDescriptor analyzedCommit, String schedulingReason, @Nullable UUID rollbackId) {
        super(workerId, projectId, triggerName, identifier, finishTime, false, LogCount.ofZero(), analyzedCommit, 0, false);
        this.schedulingReason = ShortCriticalEventWorkerLog.formatTimestampsAsDates(schedulingReason);
        this.rollbackId = rollbackId;
    }

    public String getSchedulingReason() {
        return this.schedulingReason;
    }

    @Override
    protected Stream<String> getFilterCriteria() {
        return Stream.concat(super.getFilterCriteria(), Stream.of(this.schedulingReason, Optional.ofNullable(this.rollbackId).map(UUID::toString).orElse("")));
    }

    @Override
    protected void appendFields(StringBuilder builder) {
        super.appendFields(builder);
        builder.append(this.schedulingReason).append(" (").append(this.rollbackId).append(") ");
    }
}

