/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.SerializedValueMigratorBase;
import java.io.IOException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.utils.SerializedClassFieldMigrator;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion163AddUserAvatarHash
extends SerializedValueMigratorBase {
    private static final String USER_CLASS = "com.teamscale.core.user.User";
    private static final String AVATAR_HASH_FIELD = "avatarHash";
    private static final String AVATAR_HASH_DEFAULT = "noHash";
    private static final String IGNORED_KEY = "###enabled-users###";

    public MigrateVersion163AddUserAvatarHash() {
        super(true);
    }

    @Override
    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        SerializedClassFieldMigrator fieldMigrator = new SerializedClassFieldMigrator(entityPool);
        fieldMigrator.addStringField(USER_CLASS, AVATAR_HASH_FIELD, AVATAR_HASH_DEFAULT);
    }

    @Override
    public String getStoreName() {
        return "users";
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V163;
    }

    @Override
    public EStorageMigratorType getType() {
        return EStorageMigratorType.GLOBAL;
    }

    @Override
    protected boolean isHiddenKey(byte[] key) {
        return IGNORED_KEY.equals(StringUtils.bytesToString((byte[])key));
    }
}

