/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.migration.migrators;

import com.teamscale.core.migration.MigrationException;
import com.teamscale.core.migration.store.EStorageMigratorType;
import com.teamscale.core.migration.store.EStorageSystemVersion;
import com.teamscale.core.migration.store.SerializedValueMigratorBase;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.io.ByteArrayUtils;
import org.conqat.lib.commons.serialization.SerializedEntityBase;
import org.conqat.lib.commons.serialization.SerializedEntityPool;
import org.conqat.lib.commons.serialization.classes.SerializedClass;
import org.conqat.lib.commons.serialization.classes.SerializedFieldBase;
import org.conqat.lib.commons.serialization.classes.SerializedObjectField;
import org.conqat.lib.commons.serialization.objects.SerializedObject;
import org.conqat.lib.commons.serialization.objects.SerializedStringObject;
import org.conqat.lib.commons.serialization.utils.SerializationMigrationUtils;
import org.conqat.lib.commons.serialization.utils.SerializedClassFieldMigrator;
import org.conqat.lib.commons.serialization.utils.SerializedEntityUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.ThreadSafe;

@ThreadSafe
public class MigrateVersion185UniformReportPaths
extends SerializedValueMigratorBase {
    private static final String EXTERNAL_ANALYSIS_IMPORT_INFO_CLASS = "com.teamscale.index.external.input.info.ExternalAnalysisImportInfo";
    private static final String OLD_FIELD_NAME = "reportUniformPath";
    private static final String NEW_FIELD_NAME = "reportUniformPaths";
    private static final byte[] VALUE_INDEX_PREFIX = StringUtils.stringToBytes((String)"v");
    private static final byte[] SCATTERED_COLLECTION_INDEX_SIZE_STORE_INFIX = StringUtils.stringToBytes((String)"$%$e$%$");

    public MigrateVersion185UniformReportPaths() {
        super(true);
    }

    @Override
    public EStorageSystemVersion getVersion() {
        return EStorageSystemVersion.STORAGE_SYSTEM_V185;
    }

    @Override
    public EStorageMigratorType getType() {
        return EStorageMigratorType.PROJECT;
    }

    @Override
    public String getStoreName() {
        return "external-analysis-session";
    }

    @Override
    protected boolean isHiddenKey(byte[] key) {
        return super.isHiddenKey(key) || !MigrateVersion185UniformReportPaths.isKeyToMigrate(key);
    }

    private static boolean isKeyToMigrate(byte[] key) {
        return ByteArrayUtils.isPrefix((byte[])VALUE_INDEX_PREFIX, (byte[])key) && ByteArrayUtils.contains((byte[])SCATTERED_COLLECTION_INDEX_SIZE_STORE_INFIX, (byte[])key);
    }

    @Override
    protected void migrate(SerializedEntityPool entityPool) throws StorageException, IOException, MigrationException {
        SerializedClass baseClass = entityPool.findClass(EXTERNAL_ANALYSIS_IMPORT_INFO_CLASS);
        if (baseClass == null) {
            return;
        }
        SerializedClassFieldMigrator serializedClassFieldMigrator = new SerializedClassFieldMigrator(entityPool);
        baseClass.addField((SerializedFieldBase)new SerializedObjectField(NEW_FIELD_NAME, SerializedObjectField.SET_TYPE));
        MigrateVersion185UniformReportPaths.migrateClass(baseClass, entityPool);
        List<SerializedClass> subclassesToMigrate = entityPool.getClassEntities().stream().filter(clazz -> MigrateVersion185UniformReportPaths.isSubclassOf(clazz, baseClass, entityPool)).toList();
        for (SerializedClass clazz2 : subclassesToMigrate) {
            MigrateVersion185UniformReportPaths.migrateClass(clazz2, entityPool);
        }
        serializedClassFieldMigrator.removeField(baseClass.getName(), OLD_FIELD_NAME);
    }

    private static void migrateClass(SerializedClass serializedClass, SerializedEntityPool entityPool) throws IOException {
        for (SerializedObject entity : SerializedEntityUtils.findInstancesOf((SerializedClass)serializedClass, (SerializedEntityPool)entityPool)) {
            Integer castedReportUniformPathHandle;
            SerializedStringObject serializedReportUniformPath;
            Object reportUniformPathHandle = entity.getFieldValue(OLD_FIELD_NAME);
            HashSet<String> reportUniformPaths = new HashSet<String>();
            if (reportUniformPathHandle instanceof Integer && (serializedReportUniformPath = (SerializedStringObject)entityPool.getEntity((castedReportUniformPathHandle = (Integer)reportUniformPathHandle).intValue(), SerializedStringObject.class)) != null) {
                String reportUniformPath = serializedReportUniformPath.getValue();
                reportUniformPaths.add(reportUniformPath);
            }
            SerializedEntityBase newHashSetObject = SerializationMigrationUtils.createSerializedHashSet(reportUniformPaths, (SerializedEntityPool)entityPool);
            entity.setFieldValue(NEW_FIELD_NAME, (Object)newHashSetObject.getHandle());
            entity.removeFieldValue(OLD_FIELD_NAME);
        }
    }

    private static boolean isSubclassOf(SerializedClass clazz, SerializedClass baseClass, SerializedEntityPool entityPool) {
        int superClassHandle;
        if (clazz == baseClass) {
            return false;
        }
        SerializedClass current = clazz;
        while (current != null && (superClassHandle = current.getSuperClassHandle()) != 0) {
            try {
                current = (SerializedClass)entityPool.getEntity(superClassHandle, SerializedClass.class);
                if (current != baseClass) continue;
                return true;
            }
            catch (IOException e) {
                break;
            }
        }
        return false;
    }
}

