/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.progress;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.runtime.api.progress.EAnalysisState;
import com.teamscale.core.runtime.api.scheduling.SchedulingConstants;
import com.teamscale.core.runtime.impl.analysis.JobDescriptor;
import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateBase;
import com.teamscale.core.runtime.impl.progress.GlobalAnalysisProgressIndex;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgressIndex;
import com.teamscale.core.runtime.impl.progress.RevisionAnalysisProgress;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import com.teamscale.core.utils.XXHashUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.persistence.distribution.IMessageBroker;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.SimpleCrudIndex;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.collections.DurableCollectionIndex;
import org.conqat.engine.persistence.index.collections.DurableCounterSet;
import org.conqat.engine.persistence.index.collections.DurableDistributedList;
import org.conqat.engine.persistence.index.collections.DurableSet;
import org.conqat.engine.persistence.rollback.IRollbackableIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;

public abstract sealed class AnalysisProgressIndexBase
extends IndexBase
implements IRollbackableIndex
permits GlobalAnalysisProgressIndex, ProjectAnalysisProgressIndex {
    public static final String INDEX_NAME = "analysis-progress";
    private static final String PRE_ANNOUNCEMENTS_KEY_PREFIX = "pre-announcements-";
    private final DurableCollectionIndex<CommitDescriptor> commitDescriptorDurableCollectionDelegate;
    private final DurableCollectionIndex<ScheduledJob> scheduledJobDurableCollectionDelegate;
    private final DurableCollectionIndex<JobDescriptor> jobDescriptorDurableCollectionDelegate;
    private final DurableCollectionIndex<String> stringDurableCollectionDelegate;
    private final SimpleCrudIndex<SimpleCrudIndex.ESingletonKey, ArrayList<RevisionAnalysisProgress>> analysisProgressIndex;
    private final SimpleCrudIndex<SimpleCrudIndex.ESingletonKey, EAnalysisState> analysisStateIndex;
    private final ValueIndex<BranchAnalysisStateBase<?>> branchAnalysisStateIndex;
    private final SimpleCrudIndex<EETagKey, String> analysisEtagIndex;

    protected AnalysisProgressIndexBase(IStore store) {
        super(store);
        this.commitDescriptorDurableCollectionDelegate = new DurableCollectionIndex((IStore)new DelegatingPartitionStore(store, "durable-commit-descriptor"));
        this.scheduledJobDurableCollectionDelegate = new DurableCollectionIndex((IStore)new DelegatingPartitionStore(store, "durable-scheduled-jobs"));
        this.jobDescriptorDurableCollectionDelegate = new DurableCollectionIndex((IStore)new DelegatingPartitionStore(store, "durable-job-descriptors"));
        this.stringDurableCollectionDelegate = new DurableCollectionIndex((IStore)new DelegatingPartitionStore(store, "durable-string"));
        this.analysisProgressIndex = SimpleCrudIndex.forSingleKey((IStore)new DelegatingPartitionStore(store, INDEX_NAME), (ISerializer)ISerializer.forSerializable());
        this.analysisStateIndex = SimpleCrudIndex.forSingleKey((IStore)new DelegatingPartitionStore(store, "analysis-state"), (ISerializer)ISerializer.forEnumOrdinal(EAnalysisState.class));
        this.branchAnalysisStateIndex = ValueIndex.forSerializable((IStore)new DelegatingPartitionStore(store, "branch-analysis-state"));
        this.analysisEtagIndex = new SimpleCrudIndex((IStore)new DelegatingPartitionStore(store, "analysis-etag"), ISerializer.forEnumOrdinal(EETagKey.class), ISerializer.forString());
    }

    public static AnalysisProgressIndexBase open(IndexLayer indexLayer, IProjectId projectId) throws StorageException {
        if (SchedulingConstants.isMaintenance(projectId)) {
            return indexLayer.openGlobalIndex(GlobalAnalysisProgressIndex.class);
        }
        return indexLayer.openNonHistorizedProjectIndex(ProjectAnalysisProgressIndex.class, projectId);
    }

    public List<RevisionAnalysisProgress> getProgress() throws StorageException {
        return CollectionUtils.emptyIfNull((List)this.analysisProgressIndex.get((Object)SimpleCrudIndex.ESingletonKey.INSTANCE).orElse(null));
    }

    public void setProgress(List<RevisionAnalysisProgress> progress, String newestLogEntryRepresentation) throws StorageException {
        this.analysisProgressIndex.put((Object)SimpleCrudIndex.ESingletonKey.INSTANCE, new ArrayList<RevisionAnalysisProgress>(progress));
        this.analysisEtagIndex.put((Object)EETagKey.STATE, (Object)this.computeEtag(progress, newestLogEntryRepresentation));
    }

    private String computeEtag(List<RevisionAnalysisProgress> progress, String newestLogEntryRepresentation) throws StorageException {
        StringBuilder builder = new StringBuilder(newestLogEntryRepresentation);
        builder.append(this.getETagSalt());
        for (RevisionAnalysisProgress analysisProgress : progress) {
            builder.append(analysisProgress.commit().toString()).append(analysisProgress.workDone());
        }
        return Long.toHexString(XXHashUtils.xxhash64(builder.toString()));
    }

    private String getETagSalt() throws StorageException {
        Optional salt = this.analysisEtagIndex.get((Object)EETagKey.SALT);
        if (salt.isEmpty()) {
            return this.updateETagSalt();
        }
        return (String)salt.get();
    }

    private String updateETagSalt() throws StorageException {
        String salt = StringUtils.randomString((int)20);
        this.analysisEtagIndex.put((Object)EETagKey.SALT, (Object)salt);
        return salt;
    }

    public EAnalysisState getAnalysisState() throws StorageException {
        return this.analysisStateIndex.get((Object)SimpleCrudIndex.ESingletonKey.INSTANCE).orElse(EAnalysisState.INITIAL_ANALYSIS);
    }

    public String getAnalysisStateEtag() throws StorageException {
        return this.analysisEtagIndex.get((Object)EETagKey.STATE).orElse("");
    }

    public void setAnalysisState(EAnalysisState state) throws StorageException {
        this.analysisStateIndex.put((Object)SimpleCrudIndex.ESingletonKey.INSTANCE, (Object)state);
    }

    public void storeBranchAnalysisState(String branchName, BranchAnalysisStateBase<?> state) throws StorageException {
        this.branchAnalysisStateIndex.setValue(branchName, state);
    }

    public Map<String, BranchAnalysisStateBase<?>> loadAllBranchAnalysisStates() throws StorageException {
        return this.branchAnalysisStateIndex.getAllEntries().toMap();
    }

    public DurableSet<CommitDescriptor> createDurablePreAnnouncementSet(String triggerName) throws StorageException {
        return this.commitDescriptorDurableCollectionDelegate.createLocalDurableSet(PRE_ANNOUNCEMENTS_KEY_PREFIX + triggerName);
    }

    DurableSet<CommitDescriptor> createOpenCostIgnoredCommitsSet() throws StorageException {
        return this.commitDescriptorDurableCollectionDelegate.createLocalDurableSet("openCostIgnoredCommits");
    }

    DurableCounterSet<CommitDescriptor> createWorkDoneSet() throws StorageException {
        return this.commitDescriptorDurableCollectionDelegate.createLocalDurableCounterSet("workDone");
    }

    DurableCounterSet<CommitDescriptor> createWorkOpenSet() throws StorageException {
        return this.commitDescriptorDurableCollectionDelegate.createLocalDurableCounterSet("workOpen");
    }

    public DurableSet<ScheduledJob> createAssignedJobsSet() throws StorageException {
        return this.scheduledJobDurableCollectionDelegate.createLocalDurableSet("assignedJobs");
    }

    public DurableSet<ScheduledJob> createJobQueueSet() throws StorageException {
        return this.scheduledJobDurableCollectionDelegate.createLocalDurableSet("jobQueue");
    }

    public DurableSet<String> createExhaustedTriggersSet() throws StorageException {
        return this.stringDurableCollectionDelegate.createLocalDurableSet("nonScheduledTriggers");
    }

    public DurableDistributedList<String> createExternallyScheduledTriggersSet(InternalProjectId projectId, IMessageBroker messageBroker) {
        return this.stringDurableCollectionDelegate.createDistributedDurableList("externallyScheduledTriggers", projectId, messageBroker);
    }

    public DurableDistributedList<JobDescriptor> createExternallyScheduledJobsSet(InternalProjectId projectId, IMessageBroker messageBroker) {
        return this.jobDescriptorDurableCollectionDelegate.createDistributedDurableList("externallyScheduledJobs", projectId, messageBroker);
    }

    public DurableCounterSet<String> createPeriodicExecutionCountsSet() throws StorageException {
        return this.stringDurableCollectionDelegate.createLocalDurableCounterSet("periodicExecutionCounts");
    }

    public Map<String, DurableSet<CommitDescriptor>> loadPreAnnouncements() throws StorageException {
        Map preAnnouncements = this.commitDescriptorDurableCollectionDelegate.getCreatedLocalDurableSets(PRE_ANNOUNCEMENTS_KEY_PREFIX);
        return CollectionUtils.map((Map)preAnnouncements, key -> StringUtils.stripPrefix((String)key, (String)PRE_ANNOUNCEMENTS_KEY_PREFIX), Function.identity());
    }

    public void performRollback(Map<String, Long> timestampByBranch, UUID rollbackId) throws StorageException {
        if (timestampByBranch.containsValue(0L)) {
            this.setAnalysisState(EAnalysisState.INITIAL_ANALYSIS);
        } else {
            this.setAnalysisState(EAnalysisState.getAnalysisStateAfterRollback(this.getAnalysisState()));
        }
        this.updateETagSalt();
    }

    @IndexValueClass
    private static enum EETagKey {
        STATE,
        SALT;

    }
}

