/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.progress;

import com.teamscale.core.runtime.impl.progress.BranchAnalysisStateBase;
import com.teamscale.core.runtime.impl.progress.ProjectAnalysisProgress;
import com.teamscale.core.runtime.impl.scheduling.ScheduledJob;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

@IndexValueClass
public class BranchAnalysisState
extends BranchAnalysisStateBase<Set<String>> {
    private static final long serialVersionUID = 1L;
    private final SortedMap<Long, Set<String>> writtenStoresByTimestamp = new TreeMap<Long, Set<String>>();

    @Override
    public SortedMap<Long, Set<String>> getWrittenStoresByTimestamp() {
        return this.writtenStoresByTimestamp;
    }

    @Override
    public boolean updateWrittenStores(long timestamp, Set<String> writeStores, ScheduledJob nextJob) {
        return this.writtenStoresByTimestamp.computeIfAbsent(timestamp, x -> new HashSet()).addAll(writeStores);
    }

    @Override
    public Optional<ProjectAnalysisProgress.ConflictInfo> getConflictInfo(CommitDescriptor schedulingCommit, Set<String> transitiveWriteStores, boolean isPrivilegedTrigger, @Nullable UUID rollbackId, long maximumAllowedWriteBoundary) {
        ProjectAnalysisProgress.ConflictInfo completionBoundaryConflict = this.getConflictWithCompletionBoundaryByStore(schedulingCommit, transitiveWriteStores, rollbackId, maximumAllowedWriteBoundary);
        if (completionBoundaryConflict != null) {
            return Optional.of(completionBoundaryConflict);
        }
        for (Map.Entry<Long, Set<String>> entry : this.writtenStoresByTimestamp.entrySet()) {
            boolean hasWriteOverlap;
            Long writtenTimestamp = entry.getKey();
            HashSet writeIntersection = CollectionUtils.intersectionSet((Collection)entry.getValue(), (Collection[])new Collection[]{transitiveWriteStores});
            boolean bl = hasWriteOverlap = isPrivilegedTrigger || !writeIntersection.isEmpty();
            if (maximumAllowedWriteBoundary >= writtenTimestamp || !hasWriteOverlap) continue;
            Object conflictDetails = isPrivilegedTrigger ? "Conflict due to privileged trigger." : "Conflict due to write overlap: " + String.valueOf(writeIntersection);
            return Optional.of(new ProjectAnalysisProgress.ConflictInfo(new CommitDescriptor(schedulingCommit.getBranchName(), writtenTimestamp.longValue()), (String)conflictDetails, rollbackId));
        }
        return Optional.empty();
    }
}

