/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.rollback;

import com.teamscale.core.analysis.trigger.PrivilegedTriggerBase;
import com.teamscale.core.analysis.trigger.RichCommitDescriptor;
import com.teamscale.core.analysis.trigger.RollbackRequestedCommitDescriptor;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.analysis.trigger.configuration.ETriggerCost;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.committree.ECommitTreeNodeState;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.debug.DebugDumperBase;
import com.teamscale.core.debug.DebugDumperRegistry;
import com.teamscale.core.debug.EDebugDumpEvent;
import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.log.RollbackLogMessage;
import com.teamscale.core.precommit.PreCommitUtils;
import com.teamscale.core.runtime.impl.rollback.RollbackLogIndex;
import io.prometheus.metrics.core.datapoints.DistributionDataPoint;
import io.prometheus.metrics.core.metrics.Summary;
import java.io.PrintWriter;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.ParentedCommitDescriptor;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.index.schema.SchemaAwareStorageSystem;
import org.conqat.engine.persistence.rollback.StoreRollbackUtils;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jspecify.annotations.Nullable;

public class RollbackTrigger
extends PrivilegedTriggerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String ALL_BRANCHES = "#all-branches#";
    private static final Summary ROLLBACK_SUMMARY = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.builder().name("executed_rollback_size")).help("The size of rollbacks in commits.")).labelNames(new String[]{"project"})).numberOfAgeBuckets(24).maxAgeSeconds(Duration.ofDays(1L).toSeconds()).quantile(0.5, 0.005).quantile(0.9, 0.005).quantile(0.95, 0.005).register();
    private static final Summary ROLLBACK_DURATION = (Summary)((Summary.Builder)((Summary.Builder)((Summary.Builder)Summary.builder().name("executed_rollback_duration_seconds")).help("The duration of rollbacks in seconds.")).labelNames(new String[]{"project"})).numberOfAgeBuckets(24).maxAgeSeconds(Duration.ofDays(1L).toSeconds()).quantile(0.5, 0.005).quantile(0.9, 0.005).quantile(0.95, 0.005).register();

    @Override
    public void execute() throws StorageException {
        long start = System.currentTimeMillis();
        InternalProjectId projectId = this.jobDescriptor.getInternalProjectId();
        CommitResolvingStorageSystem projectStorageSystem = this.indexLayer.openProjectStorageSystem((IProjectId)projectId);
        CommitDescriptor schedulingCommit = this.jobDescriptor.getSchedulingCommit();
        CCSMAssert.isNotNull((Object)schedulingCommit, (String)"May not perform rollback without commit!");
        ProjectInfo projectInfo = this.indexLayer.openProjectIndex().resolveProject((IProjectId)projectId);
        this.signalPreRollback(projectInfo, schedulingCommit, this.jobDescriptor.getRollbackId());
        Map<String, Long> timestampForBranch = RollbackTrigger.buildRollbackTimestampForBranchMap(schedulingCommit, projectStorageSystem);
        CounterSet<ECommitTreeNodeState> rolledBackStateCount = RollbackTrigger.determineRolledBackStateCount(projectStorageSystem, timestampForBranch);
        LOGGER.info((Message)new RollbackLogMessage("Performing rollback to " + String.valueOf(schedulingCommit), this.jobDescriptor.getRollbackId()));
        StoreRollbackUtils.performRollback((SchemaAwareStorageSystem)projectStorageSystem, timestampForBranch, (UUID)this.jobDescriptor.getRollbackId());
        this.setOutputCommit(RollbackTrigger.buildOutputCommit(schedulingCommit, timestampForBranch));
        this.signalPostRollback(projectInfo, timestampForBranch, this.jobDescriptor.getRollbackId());
        double rollbackDurationInSeconds = TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - start);
        RollbackTrigger.logRollbackInfo(projectStorageSystem, timestampForBranch, rollbackDurationInSeconds, rolledBackStateCount, this.jobDescriptor.getRollbackId());
        ((DistributionDataPoint)ROLLBACK_SUMMARY.labelValues(new String[]{projectInfo.getPrimaryPublicId().projectId})).observe((double)rolledBackStateCount.getValue((Object)ECommitTreeNodeState.PROCESSED));
        ((DistributionDataPoint)ROLLBACK_DURATION.labelValues(new String[]{projectInfo.getPrimaryPublicId().projectId})).observe(rollbackDurationInSeconds);
    }

    private static void logRollbackInfo(ProjectStorageSystem projectStorage, Map<String, Long> timestampForBranch, double executionTime, CounterSet<ECommitTreeNodeState> rolledBackStateCount, UUID rollbackId) throws StorageException {
        long minimalTimestamp = timestampForBranch.values().stream().mapToLong(x -> x).min().orElse(System.currentTimeMillis());
        RollbackLogIndex.RollbackLogEntry logEntry = new RollbackLogIndex.RollbackLogEntry(timestampForBranch.keySet(), rolledBackStateCount, minimalTimestamp, executionTime, rollbackId);
        ((RollbackLogIndex)projectStorage.openProjectIndex(RollbackLogIndex.class, null)).addLogEntry(logEntry);
    }

    public static CounterSet<ECommitTreeNodeState> determineRolledBackStateCount(ProjectStorageSystem projectStorage, Map<String, Long> timestampForBranch) throws StorageException {
        CounterSet rolledBackStateCount = new CounterSet();
        CommitTreeIndex.listCommitTrees(projectStorage).forEach((storeName, commitTree) -> {
            for (ICommitTreeNode iCommitTreeNode : commitTree.getAllNodes()) {
                if (timestampForBranch.getOrDefault(iCommitTreeNode.getBranchName(), Long.MAX_VALUE) >= iCommitTreeNode.getAdjustedTimestamp().orElse(0L)) continue;
                rolledBackStateCount.inc((Object)iCommitTreeNode.getState());
            }
        });
        return rolledBackStateCount;
    }

    private void signalPreRollback(ProjectInfo projectInfo, final CommitDescriptor schedulingCommit, @Nullable UUID rollbackId) {
        DebugDumperBase inputCommitDumper = new DebugDumperBase(this, "input-commit", true){

            @Override
            public void dump(IndexLayer indexLayer, InternalProjectId projectId, PrintWriter writer) {
                RollbackTrigger.dumpSchedulingCommit(schedulingCommit, writer);
            }
        };
        DebugDumperRegistry.getInstance().signalEvent(EDebugDumpEvent.PRE_ROLLBACK, projectInfo, this.indexLayer, rollbackId, inputCommitDumper);
    }

    private static void dumpSchedulingCommit(CommitDescriptor schedulingCommit, PrintWriter writer) {
        writer.println(schedulingCommit);
        if (schedulingCommit instanceof RichCommitDescriptor) {
            for (CommitDescriptor hint : ((RichCommitDescriptor)schedulingCommit).getSchedulingHints()) {
                writer.println("hint: " + String.valueOf(hint));
            }
        }
    }

    private void signalPostRollback(ProjectInfo projectInfo, final Map<String, Long> timestampForBranch, @Nullable UUID rollbackId) {
        DebugDumperBase timestampForBranchDumper = new DebugDumperBase(this, "rollback-map", true){

            @Override
            public void dump(IndexLayer indexLayer, InternalProjectId projectId, PrintWriter writer) {
                timestampForBranch.forEach((key, value) -> writer.println(key + " -> " + value));
            }
        };
        DebugDumperRegistry.getInstance().signalEvent(EDebugDumpEvent.POST_ROLLBACK, projectInfo, this.indexLayer, rollbackId, timestampForBranchDumper);
    }

    private static CommitDescriptor buildOutputCommit(CommitDescriptor schedulingCommit, Map<String, Long> timestampForBranch) {
        if (timestampForBranch.isEmpty()) {
            return null;
        }
        return new PostRollbackCommitDescriptor(schedulingCommit, timestampForBranch);
    }

    public static Map<String, Long> buildRollbackTimestampForBranchMap(CommitDescriptor schedulingCommit, ProjectStorageSystem projectStorageSystem) throws StorageException {
        if (PreCommitUtils.isPrecommitBranch(schedulingCommit.getBranchName())) {
            return Collections.singletonMap(schedulingCommit.getBranchName(), schedulingCommit.getTimestamp());
        }
        CommitDescriptorIndex commitDescriptorIndex = (CommitDescriptorIndex)projectStorageSystem.openProjectIndex(CommitDescriptorIndex.class, null);
        List<ParentedCommitDescriptor> allCommits = commitDescriptorIndex.getAllCommits();
        allCommits.addAll(RollbackTrigger.extractCommitsFromCommitTrees(projectStorageSystem));
        Map<String, Long> timestampForBranch = RollbackTrigger.prepareTimestampByBranchName(schedulingCommit, allCommits);
        RollbackTrigger.ensureRollbackConsistency(timestampForBranch, allCommits);
        return timestampForBranch;
    }

    private static List<ParentedCommitDescriptor> extractCommitsFromCommitTrees(ProjectStorageSystem projectStorage) throws StorageException {
        ArrayList<ParentedCommitDescriptor> allCommits = new ArrayList<ParentedCommitDescriptor>();
        CommitTreeIndex.listCommitTrees(projectStorage).forEach((storeName, commitTree) -> {
            for (ICommitTreeNode iCommitTreeNode : commitTree.getAllNodes()) {
                if (!iCommitTreeNode.getAdjustedTimestamp().isPresent()) continue;
                LOGGER.debug("Trying to create a parented commit descriptor for node: {}; parents: {}", (Object)iCommitTreeNode, iCommitTreeNode.getParents());
                ParentedCommitDescriptor commit = new ParentedCommitDescriptor(RollbackTrigger.getAdjustedCommitDescriptor(iCommitTreeNode), CollectionUtils.map(iCommitTreeNode.getParents(), RollbackTrigger::getAdjustedCommitDescriptor));
                allCommits.add(commit);
            }
        });
        return allCommits;
    }

    private static CommitDescriptor getAdjustedCommitDescriptor(ICommitTreeNode node) {
        if (node.getAdjustedTimestamp().isPresent()) {
            return node.getAdjustedCommitDescriptor();
        }
        return new CommitDescriptor(node.getRevision().getBranchName(), node.getOriginalTimestamp());
    }

    private static Map<String, Long> prepareTimestampByBranchName(CommitDescriptor schedulingCommit, List<ParentedCommitDescriptor> allCommits) {
        HashMap<String, Long> timestampForBranch = new HashMap<String, Long>();
        if (ALL_BRANCHES.equals(schedulingCommit.getBranchName())) {
            allCommits.stream().map(CommitDescriptor::getBranchName).distinct().forEach(branchName -> timestampForBranch.put((String)branchName, schedulingCommit.getTimestamp()));
        } else {
            if (!(schedulingCommit instanceof RollbackRequestedCommitDescriptor)) {
                timestampForBranch.put(schedulingCommit.getBranchName(), schedulingCommit.getTimestamp());
            }
            if (schedulingCommit instanceof RichCommitDescriptor) {
                for (CommitDescriptor commit : ((RichCommitDescriptor)schedulingCommit).getSchedulingHints()) {
                    timestampForBranch.merge(commit.getBranchName(), commit.getTimestamp(), Math::min);
                }
            }
        }
        return timestampForBranch;
    }

    private static void ensureRollbackConsistency(Map<String, Long> timestampForBranch, List<ParentedCommitDescriptor> allCommits) {
        allCommits.sort(CommitDescriptor::compareTo);
        boolean changed = true;
        while (changed) {
            changed = false;
            for (ParentedCommitDescriptor commit : allCommits) {
                if (RollbackTrigger.shouldBeDeleted((CommitDescriptor)commit, timestampForBranch) || !RollbackTrigger.shouldAnyBeDeleted((Collection<CommitDescriptor>)commit.getParentCommits(), timestampForBranch)) continue;
                changed = true;
                timestampForBranch.merge(commit.getBranchName(), commit.getTimestamp() - 1L, Math::min);
            }
        }
    }

    private static boolean shouldAnyBeDeleted(Collection<CommitDescriptor> commits, Map<String, Long> timestampForBranch) {
        for (CommitDescriptor commit : commits) {
            if (!RollbackTrigger.shouldBeDeleted(commit, timestampForBranch)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getExecutionOrderIndex() {
        return -2;
    }

    @Override
    public ETriggerConcurrency getConcurrency() {
        return ETriggerConcurrency.ROLLBACK_ISOLATED;
    }

    @Override
    public ETriggerCost getExpectedCost() {
        return ETriggerCost.EXPENSIVE;
    }

    public static boolean shouldBeDeleted(CommitDescriptor commit, Map<String, Long> timestampByBranch) {
        Long cutOffTimestamp = timestampByBranch.get(commit.getBranchName());
        return cutOffTimestamp != null && commit.getTimestamp() > cutOffTimestamp;
    }

    @IndexValueClass(containedInBackup=true)
    public static class PostRollbackCommitDescriptor
    extends CommitDescriptor {
        private static final long serialVersionUID = -1L;
        private final Map<String, Long> timestampForBranch;

        public PostRollbackCommitDescriptor(CommitDescriptor outputCommit, Map<String, Long> timestampForBranch) {
            super(outputCommit.getBranchName(), outputCommit.getTimestamp());
            this.timestampForBranch = timestampForBranch;
        }

        public Map<String, Long> getTimestampForBranch() {
            return this.timestampForBranch;
        }
    }
}

