/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.runtime.impl.util;

import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import com.teamscale.core.runtime.impl.worker.WorkerIndex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.distribution.ILockProvider;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public abstract class IndexRunnableBase {
    private static final Logger LOGGER = LogManager.getLogger();
    protected IndexLayer indexLayer;
    protected WorkerIndex workerIndex;
    protected ProjectIndex projectIndex;
    protected ILockProvider lockProvider;

    public void runEmbedded(IndexLayer indexLayer, ILockProvider lockProvider) throws StorageException {
        this.lockProvider = lockProvider;
        this.setRootStorageSystem(indexLayer);
        this.startDemons();
        LOGGER.info("Successfully started " + this.getClass().getSimpleName());
    }

    private void setRootStorageSystem(IndexLayer indexLayer) throws StorageException {
        this.indexLayer = indexLayer;
        GlobalStorageSystem globalPartition = this.indexLayer.openGlobalStorageSystem();
        this.workerIndex = (WorkerIndex)globalPartition.openGlobalIndex(WorkerIndex.class);
        this.projectIndex = (ProjectIndex)globalPartition.openGlobalIndex(ProjectIndex.class);
    }

    protected abstract void startDemons();
}

