/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.user;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.authenticate.EAuthenticationTool;
import com.teamscale.core.permissions.ESubjectType;
import com.teamscale.core.permissions.ISubject;
import com.teamscale.core.user.User;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

@IndexValueClass(containedInBackup=true)
public class UserGroup
implements Serializable,
ISubject {
    private static final long serialVersionUID = 1L;
    private static final String NAME_PROPERTY = "name";
    private static final String AUTHENTICATION_TOOL_PROPERTY = "authenticationTool";
    private static final String REMOTE_GROUP_PROPERTY = "remoteGroup";
    private static final String REMOTE_SERVER_PROPERTY = "remoteServer";
    @JsonProperty(value="userNames")
    private final Set<String> userNames = new HashSet<String>();
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="authenticationTool")
    private final EAuthenticationTool authenticationTool;
    @JsonProperty(value="remoteGroup")
    private @Nullable String remoteGroup;
    @JsonProperty(value="remoteServer")
    private @Nullable String remoteServer;

    public UserGroup(String name) {
        this(name, EAuthenticationTool.TEAMSCALE, null, null);
    }

    @JsonCreator
    public UserGroup(@JsonProperty(value="name") String name, @JsonProperty(value="authenticationTool") EAuthenticationTool authenticationTool, @JsonProperty(value="remoteGroup") @Nullable String remoteGroup, @JsonProperty(value="remoteServer") @Nullable String remoteServer) {
        CCSMAssert.isNotNull((Object)((Object)authenticationTool));
        this.name = name;
        this.authenticationTool = authenticationTool;
        this.remoteGroup = remoteGroup;
        this.remoteServer = remoteServer;
    }

    @VisibleForTesting
    public UserGroup(String name, String ... userNames) {
        this(name, EAuthenticationTool.TEAMSCALE, null, null);
        this.userNames.addAll(Arrays.asList(userNames));
    }

    public void addUser(User user) {
        this.userNames.add(user.getUsername());
    }

    public void removeUser(User user) {
        this.userNames.remove(user.getUsername());
    }

    public String getName() {
        return this.name;
    }

    public UnmodifiableSet<String> getUserNames() {
        return CollectionUtils.asUnmodifiable(this.userNames);
    }

    public boolean containsUser(String userName) {
        return this.userNames.contains(userName);
    }

    public void setUserNames(Set<String> userNames) {
        this.userNames.clear();
        this.userNames.addAll(userNames);
    }

    public boolean addUserNames(Set<String> userNames) {
        return this.userNames.addAll(userNames);
    }

    public EAuthenticationTool getAuthenticationTool() {
        return this.authenticationTool;
    }

    public boolean originatesFrom(EAuthenticationTool authenticationTool, String serverName) {
        return this.authenticationTool == authenticationTool & Objects.equals(this.remoteServer, serverName);
    }

    public @Nullable String getRemoteGroup() {
        return this.remoteGroup;
    }

    public @Nullable String getRemoteServer() {
        return this.remoteServer;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getSubjectId() {
        return this.getName();
    }

    @Override
    public ESubjectType getSubjectType() {
        return ESubjectType.GROUP;
    }

    public void setRemoteGroup(@Nullable String remoteGroup) {
        this.remoteGroup = remoteGroup;
    }
}

