/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.core.utils;

import com.teamscale.core.analysis.configuration.ConfigRegistry;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.connectors.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.index.ProjectIndex;
import java.util.List;
import java.util.Objects;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ProjectUtils {
    public static PublicProjectId resolveToPrimaryPublicId(IProjectId projectId, GlobalStorageSystem globalStorageSystem) throws StorageException {
        ProjectIndex projectIndex = (ProjectIndex)globalStorageSystem.openGlobalIndex(ProjectIndex.class);
        return projectIndex.resolveProject(projectId).getPrimaryPublicId();
    }

    public static List<PublicProjectId> resolveToPrimaryPublicId(List<ProjectInfo> projects) {
        return CollectionUtils.map(projects, ProjectInfo::getPrimaryPublicId);
    }

    public static ProjectConfiguration retrieveProjectConfig(ProjectInfo project, IndexLayer indexLayer) throws StorageException {
        return ProjectUtils.retrieveProjectConfig((IProjectId)project.getInternalId(), indexLayer);
    }

    public static ProjectConfiguration retrieveProjectConfig(IProjectId projectId, IndexLayer indexLayer) throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration(projectId, indexLayer);
        if (projectConfiguration == null) {
            return null;
        }
        return ProjectUtils.retrieveProjectConfig(projectConfiguration);
    }

    public static ProjectConfiguration retrieveProjectConfig(MetaIndex metaIndex) throws StorageException {
        return ProjectUtils.retrieveProjectConfig(Objects.requireNonNull(ProjectConfigurationUtils.getProjectConfiguration(metaIndex)));
    }

    public static ProjectConfiguration retrieveProjectConfig(ProjectConfiguration projectConfiguration) throws StorageException {
        for (ConnectorConfiguration connectorConfiguration : projectConfiguration.getConnectors()) {
            ConnectorDescriptorBase connectorDescriptor = ConfigRegistry.getInstance().createConnectorDescriptor(connectorConfiguration.getType());
            CCSMAssert.isNotNull((Object)connectorDescriptor, (String)("Unknown connector type '" + connectorConfiguration.getType() + "' used in project " + String.valueOf(projectConfiguration.getPrimaryPublicId())));
            UnmodifiableList<ConfigOptionDescriptorBase> configOptions = connectorDescriptor.getVisibleOptions();
            connectorConfiguration.initializeDefaults((List<ConfigOptionDescriptorBase>)configOptions);
            connectorConfiguration.sortOptionMap(CollectionUtils.sort(configOptions, ConfigOptionDescriptorBase.getByVisibilityComparator()));
        }
        return projectConfiguration;
    }

    private ProjectUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

