/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.logging;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.log.LogIndexBase;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.assertion.CCSMAssert;

public class ProjectLogLevelFrequencies {
    @JsonProperty(value="project")
    public final PublicProjectId project;
    @JsonProperty(value="info")
    public final int info;
    @JsonProperty(value="warn")
    public final int warn;
    @JsonProperty(value="error")
    public final int error;
    @JsonProperty(value="fatal")
    public final int fatal;

    public ProjectLogLevelFrequencies(PublicProjectId project, int[] frequencies) {
        this.project = project;
        this.info = frequencies[LogIndexBase.EIndexLogLevel.INFO.ordinal()];
        this.warn = frequencies[LogIndexBase.EIndexLogLevel.WARN.ordinal()];
        this.error = frequencies[LogIndexBase.EIndexLogLevel.ERROR.ordinal()];
        this.fatal = frequencies[LogIndexBase.EIndexLogLevel.FATAL.ordinal()];
    }

    private ProjectLogLevelFrequencies(PublicProjectId project, int info, int warn, int error, int fatal) {
        this.project = project;
        this.info = info;
        this.warn = warn;
        this.error = error;
        this.fatal = fatal;
    }

    public static ProjectLogLevelFrequencies merge(ProjectLogLevelFrequencies frequency1, ProjectLogLevelFrequencies frequency2) {
        CCSMAssert.isTrue((boolean)frequency1.project.equals((Object)frequency2.project), (String)"Frequencies must match!");
        return new ProjectLogLevelFrequencies(frequency1.project, frequency1.info + frequency2.info, frequency1.warn + frequency2.warn, frequency1.error + frequency2.error, frequency1.fatal + frequency2.fatal);
    }
}

