Array initialization should be performed using a brace-enclosed list of initializers, and happen once and for all array elements.

# Why is This a Problem?
Partially initialized arrays are error-prone, as uninitialized array elements may be unexpected.

# How Can I Resolve This?
This can be resolved by 
1. using enclosing braces for every sub-object
2. initializing every array element exactly once

## Example (Before)

``` cpp
int arr1[2][2] = {{1}, {2}};
int arr2[2][2] = {1, 2, 3, 4};
```
In the first array, not all elements are initialized.
In the second array, all elements are initialized but braces for sub-objects are missing.

## Example (After)

``` cpp
int arr[2][2] = {{1, 2}, {3, 4}};
```



