Do not assign the result of an expression to a wider essential type.
* MISRA C:2012, 10.6 - The value of a composite expression shall not be assigned to an object with wider essential type

The C type system allows assignments between different arithmetic types and does the type conversion automatically.
Using these implicit conversions can lead to unintended loss of value, sign or precision.

This check uses the *MISRA essential type model*, which enforces a stronger type model and reduces the likelihood of such problems.
The essential-type model defines the type categories Boolean, character, signed, unsigned, enum, and floating.
Types within a category are compared by their byte size (*wider* means more bytes).
The model is quite complex and can't be explained completely here.

This check reports situations where the result of a *composite* expression is assigned to a *wider* essential type.
This may be problematic because the resulting value is sometimes not what would be expected.
If you are sure that the behavior is correct, you can insert an explicit cast to avoid the finding and document the intention.

Example:
```c
typedef unsigned long long uint64_t;
typedef unsigned int uint32_t;
void print(uint64_t num) {
    printf("%lu\n", num);
}
uint32_t x32 = 4294967295;
print(x32 + x32); // prints 4294967294 (finding)

uint64_t x64 = x32;
print(x64 + x64); // prints 8589934590
```
Notes: 
* Our analysis assumes that the code is compiled for a 64 bit system.
* The check applies to C code only (not to C++)


