The header file associated with this source file was included after other header files.

# What Does This Check Look For?

This check searches for include directives that include header files with the same name as the source file, and reports a finding if the directive is placed after other include directives.

# Why is This a Problem?

Besides conformance reasons, including header files associated with source files in the first position helps to find build failures in own code quickly.

# How Can I Resolve This?

Move the include directive for this header before all other include directives.

# Examples
## Non-Compliant

```cpp
// foo.cpp
#include <string>
#include "foo.h"    // non-compliant: include for std::string is placed first

...
```

## Compliant
```cpp
// foo.cpp
#include "foo.h"    // compliant: include for own header is placed first
#include <string>

...
```

# Where Can I Learn More?
- [Google C++ Style Guide: Names and Order of Includes](https://google.github.io/styleguide/cppguide.html#Names_and_Order_of_Includes)