Improper initialization of static variables can lead to unexpected behavior.
Static variables that are not protected or private should be initialized directly or in a static initializer.

# What Does This Check Look For?

This check flags public and package-private static variables that are neither initialized directly nor initialized in a static initializer.

# Why is This a Problem?

Uninitialized static variables are a common source of bugs, as their default values may not be what is expected, leading to unpredictable application behavior. Especially for non-primitive types, relying on default initialization could result in null references or default values that are inappropriate for the application logic. Furthermore, explicit initialization of static variables enhances code readability and maintainability by making the developer's intentions clear.

# How Can I Resolve This?

- Directly initialize the static variable at the point of declaration. This is often the simplest and most straightforward method.
- Alternatively, use a static initialization block to initialize the variable. This approach is useful when the initialization logic is complex.

Both methods ensure that the static variable is assigned a meaningful and predictable value before its first use, thus avoiding unintended behavior.

# Examples

## Non-Compliant

```java
public class Example {
    public static String myStaticVar; // non-compliant: not initialized
}
```

## Compliant

```java
public class Example {
    public static String myStaticVar = "initialized"; // compliant: directly initialized

    // Or, using a static initializer block
    static {
        myStaticVar = "initialized";
    }
}
```