<h2>Why is this an issue?</h2>
<p>Describing, setting error message or adding a comparator in <a href="https://assertj.github.io/doc/">AssertJ</a> must be done before calling the
assertion, otherwise, settings will not be taken into account.</p>
<p>This rule raises an issue when one of the method (with all similar methods):</p>
<ul>
  <li> <code>as</code> </li>
  <li> <code>describedAs</code> </li>
  <li> <code>withFailMessage</code> </li>
  <li> <code>overridingErrorMessage</code> </li>
  <li> <code>usingComparator</code> </li>
  <li> <code>usingElementComparator</code> </li>
  <li> <code>extracting</code> </li>
  <li> <code>filteredOn</code> </li>
</ul>
<p>is called without calling an AssertJ assertion afterward.</p>
<h3>Noncompliant code example</h3>

```java
assertThat(actual).isEqualTo(expected).as("Description"); // Noncompliant
assertThat(actual).isEqualTo(expected).withFailMessage("Fail message"); // Noncompliant
assertThat(actual).isEqualTo(expected).usingComparator(new CustomComparator()); // Noncompliant
```
<h3>Compliant solution</h3>

```java
assertThat(actual).as("Description").isEqualTo(expected);
assertThat(actual).withFailMessage("Fail message").isEqualTo(expected);
assertThat(actual).usingComparator(new CustomComparator()).isEqualTo(expected);
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://assertj.github.io/doc/#calling-as-after-the-assertion">AssertJ incorrect usage documentation</a> </li>
</ul>