import{_ as a,c as t,ak as i,o as n}from"./chunks/framework.D4LivsWb.js";const o="data:image/png;base64,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",s="data:image/png;base64,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",f=JSON.parse('{"title":"Glossary","description":"","frontmatter":{},"headers":[],"relativePath":"glossary/index.md","filePath":"glossary/index.md"}'),r={name:"glossary/index.md"};function l(c,e,h,d,m,p){return n(),t("div",null,[...e[0]||(e[0]=[i('<h1 id="glossary" tabindex="-1">Glossary <a class="header-anchor" href="#glossary" aria-label="Permalink to &quot;Glossary&quot;">​</a></h1><p>You may stumble upon some unfamiliar terms in Teamscale documentation. This glossary lists the common terms used throughout the documentation.</p><h2 id="access-key" tabindex="-1">Access Key <a class="header-anchor" href="#access-key" aria-label="Permalink to &quot;Access Key&quot;">​</a></h2><p>The access key is used to authentication with Teamscale&#39;s REST API, e.g., when accessing Teamscale from our IDE plugins or scripts. Teamscale requires this key, instead of the password, to avoid that user passwords are stored and sent by tools communicating through the REST API, and to prevent that scripts break when passwords change (e.g., due to company policies). Every Teamscale user can generate such a key on their personal profile page <code>&lt;TEAMSCALE_URL&gt;/user/access-key</code>, also accessible via the user icon in the upper right corner.</p><h2 id="analysis-group" tabindex="-1">Analysis Group <a class="header-anchor" href="#analysis-group" aria-label="Permalink to &quot;Analysis Group&quot;">​</a></h2><p>An analysis group is an aspect of a quality indicator that exposes options for passing data in order to influence analysis of code in Teamscale. The options may be of metrics or running of custom checks.</p><h2 id="analysis-profile" tabindex="-1">Analysis Profile <a class="header-anchor" href="#analysis-profile" aria-label="Permalink to &quot;Analysis Profile&quot;">​</a></h2><p>An analysis profile comprises a set of analyses and their configurations. For each language, there is a default analysis profile, but Teamscale users can also configure their individual profiles tailored to suit their needs.</p><h2 id="ant-pattern" tabindex="-1">Ant Pattern <a class="header-anchor" href="#ant-pattern" aria-label="Permalink to &quot;Ant Pattern&quot;">​</a></h2><p>A pattern, as used by Ant and other tools, to match one or more paths. A question mark (<code>?</code>) matches a single character within a path component but not the path separator. Likewise, a single asterisk (*) matches zero or more characters within a path component but not the path separator. In contrast, a double asterisk (<code>**</code>) matches zero or more characters including the path separator. Examples if Ant patterns are <code>**/*.java</code> or <code>include/*.?.</code></p><h2 id="assessment-metric" tabindex="-1">Assessment Metric <a class="header-anchor" href="#assessment-metric" aria-label="Permalink to &quot;Assessment Metric&quot;">​</a></h2><p>An assessment metric is a metric which divides the system into parts belonging to the green assessment, the yellow and the red one. Example: The metric File Size is an assessment metric. Green files are, for example, those with less than 300 SLOC, yellow are those with less than 750 SLOC and the remaining ones are red.</p><h2 id="baseline" tabindex="-1">Baseline <a class="header-anchor" href="#baseline" aria-label="Permalink to &quot;Baseline&quot;">​</a></h2><p>A baseline is a point in time defined by the user. A baseline is often used as reference point to compare the current quality status against, for example in the delta analysis. In Teamscale, a baseline is defined with a calendar date and a corresponding label. It is thereby independent of the underlying branch in case branch support is enabled.</p><h2 id="branch-and-timestamp" tabindex="-1">Branch and Timestamp <a class="header-anchor" href="#branch-and-timestamp" aria-label="Permalink to &quot;Branch and Timestamp&quot;">​</a></h2><p>As Teamscale supports several version control systems, it allows to use a VCS agnostic system to point to a specific code commit. The format of this system is <em>branchName:timestamp</em>. The timestamp is either the elapsed milliseconds since epoch (e.g. 1576093049000 = Wed Dec 11 2019 19:37:29 UTC) or &quot;HEAD&quot;. HEAD points to the latest commit.</p><p>The timestamp can be seen in the URL of the commit in Teamscale. It is the value of the query parameter <code>t</code> e.g. <code>t=release%2F4.2.3%3A1576093049000</code> in URL encoded format can be decoded to <code>t=release/4.2.3:1576093049000</code> which gives the <em>Branch and Timestamp</em> of <code>release/4.2.3:1576093049000</code></p><p>Examples:</p><ul><li><code>master:HEAD</code>: The most recent commit known to Teamscale in the master branch.</li><li><code>my-branch:1576093049000</code>: Branch and timestamp.</li></ul><h2 id="branch-support" tabindex="-1">Branch Support <a class="header-anchor" href="#branch-support" aria-label="Permalink to &quot;Branch Support&quot;">​</a></h2><p>If enabled, the branch support feature allows Teamscale to not only analyze the »master« or »trunk« of a repository, but also its branches.</p><h2 id="change-count" tabindex="-1">Change Count <a class="header-anchor" href="#change-count" aria-label="Permalink to &quot;Change Count&quot;">​</a></h2><p>This metric counts how many commits every source code file changed over a particular time interval (e.g., from one commit to another, or for the whole history computed in Teamscale). The Change Count metric is applied to every file modified in the computed history, and can be aggregated hierarchically by source code folder all the way up to the project root. Note this metric depends on which branch you look, since a merge commit from one branch to another will count only once, rather than adding up all commits that possibly changed a given file before merge on the source branch. Also, file addition and deletion do not count.</p><h2 id="clone-coverage" tabindex="-1">Clone Coverage <a class="header-anchor" href="#clone-coverage" aria-label="Permalink to &quot;Clone Coverage&quot;">​</a></h2><p>The clone coverage indicates the percentage of code lines which are covered by at least one clone. It can be interpreted as the probability that a random (evenly distributed) change to a code line needs to be propagated to at least one other clone instance.</p><h2 id="component" tabindex="-1">Component <a class="header-anchor" href="#component" aria-label="Permalink to &quot;Component&quot;">​</a></h2><p>In an architecture specification, a system is modeled as a hierarchy of components. A component has a unique name and may have sub-components and mappings.</p><h2 id="custom-artifact-metric" tabindex="-1">Custom Artifact Metric <a class="header-anchor" href="#custom-artifact-metric" aria-label="Permalink to &quot;Custom Artifact Metric&quot;">​</a></h2><p>A metric that is attached to custom artifacts, e.g., the build status of your system. Teamscale offers a flexible mechanism to integrate show such custom metrics.</p><h2 id="custom-check" tabindex="-1">Custom Check <a class="header-anchor" href="#custom-check" aria-label="Permalink to &quot;Custom Check&quot;">​</a></h2><p>A custom check is an analysis implemented by the user which can be integrated in Teamscale. Teamscale also comes with a large set of pre-written checks.</p><h2 id="cyclomatic-complexity" tabindex="-1">Cyclomatic Complexity <a class="header-anchor" href="#cyclomatic-complexity" aria-label="Permalink to &quot;Cyclomatic Complexity&quot;">​</a></h2><p>This metric is also known as the »McCabe metric«. It measures the number of linearly independent paths through a program&#39;s source code. It is useful for establishing the number of test cases needed to cover the control flow of the method completely, but is not a good predictor for method complexity. The implementation used by Teamscale employs the definition given in <a href="https://doi.org/10.1109/tse.1976.233837" target="_blank" rel="noreferrer">McCabe&#39;s original paper</a>.</p><h2 id="delta" tabindex="-1">Delta <a class="header-anchor" href="#delta" aria-label="Permalink to &quot;Delta&quot;">​</a></h2><p>The delta between two snapshots contains the changes from the repository between a start date and an end date as well as differences in the quality status. It also contains the differences in metric values and assessments as well as the finding churn, for example. Often, the start date is referred to as baseline for the delta.</p><h2 id="delta-analysis" tabindex="-1">Delta Analysis <a class="header-anchor" href="#delta-analysis" aria-label="Permalink to &quot;Delta Analysis&quot;">​</a></h2><p>The delta analysis computes the <a href="#delta">delta</a>.</p><h2 id="dialog" tabindex="-1">Dialog <a class="header-anchor" href="#dialog" aria-label="Permalink to &quot;Dialog&quot;">​</a></h2><p>A dialog is a UI element of the Teamscale web interface. It pops up dynamically when the user performs certain tasks and closes when the user has completed the respective task. The user has to press a button to close a dialog.</p><h2 id="excluded-finding" tabindex="-1">Excluded Finding <a class="header-anchor" href="#excluded-finding" aria-label="Permalink to &quot;Excluded Finding&quot;">​</a></h2><p>An excluded finding is either <a href="#tolerated-finding">tolerated</a> or <a href="#false-positive-finding">marked as false-positive</a>.</p><h2 id="external-finding" tabindex="-1">External Finding <a class="header-anchor" href="#external-finding" aria-label="Permalink to &quot;External Finding&quot;">​</a></h2><p>An external finding is a finding created externally by other tools and uploaded to Teamscale. Each upload of external findings will show as an <a href="#external-upload-commit">external upload commit</a> in Teamscale.</p><h2 id="external-metric" tabindex="-1">External Metric <a class="header-anchor" href="#external-metric" aria-label="Permalink to &quot;External Metric&quot;">​</a></h2><p>In contrast to metrics created internally by Teamscale, an external metric can be a code metric or any <a href="#custom-artifact-metric">custom artifact metric</a> externally created and uploaded to Teamscale. Each upload of external metrics will show as an <a href="#external-upload-commit">external upload commit</a> in Teamscale.</p><h2 id="external-upload-commit" tabindex="-1">External Upload Commit <a class="header-anchor" href="#external-upload-commit" aria-label="Permalink to &quot;External Upload Commit&quot;">​</a></h2><p>These commits are not present in the version control system of the project, but artificially added to Teamscale. They provide data from external analysis tools, such as test coverage tools, and build scripts, for example.</p><h2 id="false-positive-finding" tabindex="-1">False Positive Finding <a class="header-anchor" href="#false-positive-finding" aria-label="Permalink to &quot;False Positive Finding&quot;">​</a></h2><p>A false positive finding denotes a finding which has been incorrectly detected by the analysis, i.e., the static analysis produced a finding even though there is no violation present. To mark a finding as false positive means that this finding will be put in the false positive findings section and not shown directly anymore. In the Code Detail View or in the IDE integration, it will be not shown at all. It can, however, still be inspected in the False Positive View.</p><h2 id="file-dependency" tabindex="-1">File Dependency <a class="header-anchor" href="#file-dependency" aria-label="Permalink to &quot;File Dependency&quot;">​</a></h2><p>In a file-based architecture, the path to the source code files are used for dependencies.</p><h2 id="finding" tabindex="-1">Finding <a class="header-anchor" href="#finding" aria-label="Permalink to &quot;Finding&quot;">​</a></h2><p>A finding refers to a specific region in the code, that is likely to hamper software quality. The region in the code is referred to as finding location. Generally, a finding belongs to one finding group. A finding can occur when a metric and its corresponding threshold are violated, for example, when a file exceeds the size limit of 300 SLOC. Then this overly long file becomes a finding. Alternatively, a finding can directly result from a quality analysis. The code clone detection, for example, reveals clones as findings. These clones do not result from a threshold violation of the corresponding clone coverage metric, but are findings themselves. Each finding has an introduction date in Teamscale.</p><h2 id="findings-badge" tabindex="-1">Findings Badge <a class="header-anchor" href="#findings-badge" aria-label="Permalink to &quot;Findings Badge&quot;">​</a></h2><p>Teamscale can add findings badges when <a href="#voting">voting</a> on merge requests. They represent an easy to comprehend visualization of the findings churn between two commits (in this case, the merge source and target).</p><p><img src="'+o+'" alt="Findings Badge" width="160" height="18"></p><p>A findings badge can be read as follows:</p><ul><li>Red: Findings which have been added in this churn.</li><li>Blue: Old findings in code, which has been changed in this churn.</li><li>Green: Resolved findings in this churn.</li></ul><h2 id="finding-description" tabindex="-1">Finding Description <a class="header-anchor" href="#finding-description" aria-label="Permalink to &quot;Finding Description&quot;">​</a></h2><p>A finding description provides information about the nature of the finding and its impact on quality. For external findings, finding descriptions are used to associate findings with their findings group.</p><h2 id="finding-group" tabindex="-1">Finding Group <a class="header-anchor" href="#finding-group" aria-label="Permalink to &quot;Finding Group&quot;">​</a></h2><p>A finding group describes a single analysis or a group of analyses creating findings. For example, there are three different finding groups »File Size«, »Method Length« and »Nesting Depth« which represent one analysis each. The finding group »Comment quality« comprises several analyses, detecting unrelated member comments or empty interface comments, for example. A finding group is always associated with one finding category.</p><h2 id="finding-category" tabindex="-1">Finding Category <a class="header-anchor" href="#finding-category" aria-label="Permalink to &quot;Finding Category&quot;">​</a></h2><p>A finding category combines several finding groups. For example, the finding category »Structure« contains the three groups »File Size«, »Method Length« and »Nesting Depth«. A finding category represents a quality indicator.</p><h2 id="finding-location" tabindex="-1">Finding Location <a class="header-anchor" href="#finding-location" aria-label="Permalink to &quot;Finding Location&quot;">​</a></h2><p>The location can span several files (e.g., a code clone), a single file (e.g., an overly long file), a method (e.g., an unused method) or a single line (e.g., a naming convention violation).</p><h2 id="findings-count" tabindex="-1">Findings Count <a class="header-anchor" href="#findings-count" aria-label="Permalink to &quot;Findings Count&quot;">​</a></h2><p>This metric denotes the number of all findings for a project. Naturally, it depends on which analyses are configured.</p><h2 id="findings-churn" tabindex="-1">Findings Churn <a class="header-anchor" href="#findings-churn" aria-label="Permalink to &quot;Findings Churn&quot;">​</a></h2><p>A finding churn indicates for a given time internal, how many findings were added to or removed from the system.</p><h2 id="impacted-test" tabindex="-1">Impacted Test <a class="header-anchor" href="#impacted-test" aria-label="Permalink to &quot;Impacted Test&quot;">​</a></h2><p>An Impacted Test for a given set of changes is a test that executes some of the changed methods.</p><h2 id="introduction-date" tabindex="-1">Introduction Date <a class="header-anchor" href="#introduction-date" aria-label="Permalink to &quot;Introduction Date&quot;">​</a></h2><p>The introduction date refers to the revision in which a finding was first detected by Teamscale. For internal analysis, this refers to the revision with which the developer introduced the finding in the code base. For external analysis, which are integrated via a nightly build, this refers to the revision with which the finding was first uploaded to Teamscale. Hence, the introduction date then refers to the first detection time, not the actual introduction time.</p><h2 id="issue-metric" tabindex="-1">Issue Metric <a class="header-anchor" href="#issue-metric" aria-label="Permalink to &quot;Issue Metric&quot;">​</a></h2><p>An issue metric is the numeric result of an issue query which can be saved in Teamscale and, thus, be used continuously.</p><h2 id="java-timestamp-unix-timestamp" tabindex="-1">Java timestamp / Unix Timestamp <a class="header-anchor" href="#java-timestamp-unix-timestamp" aria-label="Permalink to &quot;Java timestamp / Unix Timestamp&quot;">​</a></h2><p>The Unix epoch time (time since January 1, 1970 00:00:00.000 GMT) in milliseconds.</p><h2 id="lines-of-code" tabindex="-1">Lines of Code <a class="header-anchor" href="#lines-of-code" aria-label="Permalink to &quot;Lines of Code&quot;">​</a></h2><p>Abbreviated as LOC, this metric counts all lines of code of a file as displayed to the developer. The count includes empty lines and comments. See also <a href="#source-lines-of-code">Source Lines of Code</a>.</p><h2 id="mapping" tabindex="-1">Mapping <a class="header-anchor" href="#mapping" aria-label="Permalink to &quot;Mapping&quot;">​</a></h2><p>Mappings between code and architecture define which implementation artifacts belong to which component in the architecture definition. If the architecture is based on file dependencies, a mapping specifies which files belong a component. For type dependencies, it specifies which types map to a component.</p><h2 id="mapping-file" tabindex="-1">Mapping File <a class="header-anchor" href="#mapping-file" aria-label="Permalink to &quot;Mapping File&quot;">​</a></h2><p>Contain mappings from the information in a coverage file to the original source code lines, e.g., line number translation tables or mappings from method IDs to source code lines.</p><h2 id="method-length" tabindex="-1">Method Length <a class="header-anchor" href="#method-length" aria-label="Permalink to &quot;Method Length&quot;">​</a></h2><p>This metric is an assessment metric and denotes the distribution of code in short (green), long (yellow) and very long (red) methods. The length of each method category is configured by a threshold in the analysis profile.</p><h2 id="metric" tabindex="-1">Metric <a class="header-anchor" href="#metric" aria-label="Permalink to &quot;Metric&quot;">​</a></h2><p>A metric captures an automatically measurable aspect of software quality. In can either be a numeric metric or an assessment metric.</p><h2 id="nesting-depth" tabindex="-1">Nesting Depth <a class="header-anchor" href="#nesting-depth" aria-label="Permalink to &quot;Nesting Depth&quot;">​</a></h2><p>This metric is an assessment metric and denotes the distribution of code over methods with shallow (green), deep (yellow) and very deep (red) nesting. Each nesting category is configured by a threshold in the analysis profile.</p><h2 id="numeric-metric" tabindex="-1">Numeric Metric <a class="header-anchor" href="#numeric-metric" aria-label="Permalink to &quot;Numeric Metric&quot;">​</a></h2><p>A numeric metric is a metric that consists of a single numeric value. Example: The clone coverage is an example of a numeric metric. Its value could be 20%. Another example is the metric number of files. Its value could be 4000.</p><h2 id="orphan" tabindex="-1">Orphan <a class="header-anchor" href="#orphan" aria-label="Permalink to &quot;Orphan&quot;">​</a></h2><p>If a file or a type are not mapped to any component in an architecture specification, they are marked as orphan.</p><h2 id="page" tabindex="-1">Page <a class="header-anchor" href="#page" aria-label="Permalink to &quot;Page&quot;">​</a></h2><p>A page is a UI element of Teamscale’s web interface. If a perspective has a sidebar on the right hand side, then each entry in this sidebar represents a page.</p><h2 id="partition" tabindex="-1">Partition <a class="header-anchor" href="#partition" aria-label="Permalink to &quot;Partition&quot;">​</a></h2><p>A partition is a logical group of external analysis data, identified by a label (an arbitrary string that should be descriptive of the group). Whenever you upload external data, such as code coverage or analysis findings, to Teamscale, you must specify a partition. The partition is implicitly created by the first upload to it. Subsequent uploads to a partition will overwrite all data previously uploaded to the same partition.</p><p>For example, if you collect code coverage of both your unit tests and your automated UI tests, you would upload the coverage from either test stage to a distinct partition, say <code>Unit Tests</code> and <code>UI Tests</code>. Teamscale will then consider the union of both partitions, i.e., a line in your source code is then counted as covered, if it is either covered by the unit or by the UI tests or both.</p><h2 id="perspective" tabindex="-1">Perspective <a class="header-anchor" href="#perspective" aria-label="Permalink to &quot;Perspective&quot;">​</a></h2><p>A perspective is the main UI element in Teamscale. Toplevel, Teamscale consists of several different perspectives which can be navigated in the top header row of the web UI.</p><h2 id="policy" tabindex="-1">Policy <a class="header-anchor" href="#policy" aria-label="Permalink to &quot;Policy&quot;">​</a></h2><p>A policy in an architecture specification determines which components may be in a relationship (allow, deny, tolerate) with each other.</p><h2 id="pre-commit-analysis" tabindex="-1">Pre-Commit Analysis <a class="header-anchor" href="#pre-commit-analysis" aria-label="Permalink to &quot;Pre-Commit Analysis&quot;">​</a></h2><p>Pre-commit analysis allows a Teamscale client like an IDE plug-in to submit source code for analysis to the Teamscale server even though the code hasn&#39;t been committed to a version control system yet. The server then analyzes the code changes on-the-fly and informs the client about any change to the number of findings that would occur were the code changes actually committed.</p><h2 id="quality-report" tabindex="-1">Quality Report <a class="header-anchor" href="#quality-report" aria-label="Permalink to &quot;Quality Report&quot;">​</a></h2><p>A quality report is a document reflecting the overall quality of a project and the trends in project quality since a baseline. A quality report may contain findings from project code, metrics, tasks and other aspects of project quality. A Teamscale-generated quality report is a collection of slides, each reflecting a certain aspect of project quality.</p><h2 id="quality-indicator" tabindex="-1">Quality Indicator <a class="header-anchor" href="#quality-indicator" aria-label="Permalink to &quot;Quality Indicator&quot;">​</a></h2><p>A quality indicator denotes a certain quality aspect. For example, »Structure« or »Code Duplication« represent quality indicators.</p><h2 id="quality-goal" tabindex="-1">Quality Goal <a class="header-anchor" href="#quality-goal" aria-label="Permalink to &quot;Quality Goal&quot;">​</a></h2><p>A quality goal represents the target line for the quality status of a system. It can have one of the following four values: perfect (no findings at all), improving (no new findings and no findings in modified code), preserving (no new findings) or none (any number of findings).</p><h2 id="requirements-tracing" tabindex="-1">Requirements Tracing <a class="header-anchor" href="#requirements-tracing" aria-label="Permalink to &quot;Requirements Tracing&quot;">​</a></h2><p>Requirements Tracing is a Teamscale analysis that helps you establish a traceable connection between the <a href="#specification-item">spec items</a> in your requirements management system, the code entities (classes, methods, etc.) that implement specific items, and the tests that ensure the spec items have been correctly implemented. The building blocks of the analysis are the Requirement Management Tool connectors, source code comment analysis and static test case extraction.</p><h2 id="revision" tabindex="-1">Revision <a class="header-anchor" href="#revision" aria-label="Permalink to &quot;Revision&quot;">​</a></h2><p>A revision uniquely identifies a commit, i.e., a change to one or more files, in a version control system. As an example, in Git, commits are identified by their SHA-1 Hash. Instead of using the whole hash value, a unique prefix is enough to identify the commit.</p><h2 id="rollback" tabindex="-1">Rollback <a class="header-anchor" href="#rollback" aria-label="Permalink to &quot;Rollback&quot;">​</a></h2><p>If Teamscale detects an inconsistency or change in the analyzed data, it will automatically trigger a rollback to the date of the change. This means that Teamscale will reanalyze all the commits that are affected by the change, to ensure that all the changes are propagated through the commit history. A rollback typically occurs when the commit structure has changed (e.g. due to <code>git rebase</code>) or external reports have been uploaded.</p><h2 id="section" tabindex="-1">Section <a class="header-anchor" href="#section" aria-label="Permalink to &quot;Section&quot;">​</a></h2><p>A section is a part of a view that is independent of the other content of that view, e.g., one of the main tables of the Metrics perspective.</p><h2 id="severity" tabindex="-1">Severity <a class="header-anchor" href="#severity" aria-label="Permalink to &quot;Severity&quot;">​</a></h2><p>The severity of a finding is expressed by either a yellow or a red color. It can be configured in the analysis profile and used to filter findings.</p><h2 id="size-metric" tabindex="-1">Size Metric <a class="header-anchor" href="#size-metric" aria-label="Permalink to &quot;Size Metric&quot;">​</a></h2><p>A size metric indicates the size of a system. It can either count the number of files, lines of code, or source lines of code.</p><h2 id="shadow-instance" tabindex="-1">Shadow Instance <a class="header-anchor" href="#shadow-instance" aria-label="Permalink to &quot;Shadow Instance&quot;">​</a></h2><p>A second instance of Teamscale that is run in parallel to your production instance during feature version updates. This allows your users to still access the old version of Teamscale while the new one is still analyzing.</p><h2 id="shadow-mode" tabindex="-1">Shadow Mode <a class="header-anchor" href="#shadow-mode" aria-label="Permalink to &quot;Shadow Mode&quot;">​</a></h2><p>In this mode, Teamscale will not publish data to external systems (e.g., via notifications or merge-request annotations) and will not fetch data from SAP systems. See also our <a href="./../reference/admin-settings/server-settings/#shadow-mode">admin documentation</a>.</p><h2 id="source-lines-of-code" tabindex="-1">Source Lines of Code <a class="header-anchor" href="#source-lines-of-code" aria-label="Permalink to &quot;Source Lines of Code&quot;">​</a></h2><p>Abbreviated as SLOC, this metric counts the total lines of code of a file as displayed to the developer, and subtracts blank lines and comment lines.</p><h2 id="specification-item" tabindex="-1">Specification Item <a class="header-anchor" href="#specification-item" aria-label="Permalink to &quot;Specification Item&quot;">​</a></h2><p>A specification item (or spec item) in Teamscale is a unit of work managed in a requirements management system. Examples of spec items include system/software requirement items, parent component items, test case items, etc.</p><h2 id="task" tabindex="-1">Task <a class="header-anchor" href="#task" aria-label="Permalink to &quot;Task&quot;">​</a></h2><p>A task in Teamscale is a concept to schedule findings for removal and keep track of the process. Multiple findings can be grouped together to one task.</p><h2 id="test-execution" tabindex="-1">Test Execution <a class="header-anchor" href="#test-execution" aria-label="Permalink to &quot;Test Execution&quot;">​</a></h2><p>A test execution is a single data point for a test that was executed. It includes which result the test produced (passed, failed, skipped, etc.), how long it took to execute and optionally an error message.</p><h2 id="test-gap" tabindex="-1">Test Gap <a class="header-anchor" href="#test-gap" aria-label="Permalink to &quot;Test Gap&quot;">​</a></h2><p>A Test Gap is a method in the source code of your software system whose behavior was changed and that has not been executed in tests since that change. Let&#39;s look at the individual parts of this definition:</p><ol><li>A Test Gap is in your <em>source code</em>. TGA cannot identify changes to the behavior of your software system that are caused by changes in configuration or data, because we cannot generally determine which parts of a system are effected by such changes.</li><li>A Test Gap contains a <em>behavioral change</em>. To identify such changes, Teamscale analyses the change history in your source code repository. Moreover, it applies a refactoring detection, to filter changes that are not behavioral, such as changes to code comments or renaming of variables, methods, classes or packages.</li><li>A Test Gap has <em>not been executed in any test</em>. Therefore, you cannot have found any defect hidden in a Test Gap in your testing. Note that the inverse does not hold: Code changes that have been executed in one or multiple tests may still contain defects. As with any testing approach, TGA cannot guarantee the absence of defects.</li></ol><h2 id="test-gap-analysis" tabindex="-1">Test Gap Analysis <a class="header-anchor" href="#test-gap-analysis" aria-label="Permalink to &quot;Test Gap Analysis&quot;">​</a></h2><p>The Test Gap Analysis (TGA) can detect holes in the test process by uncovering code that was not tested after its latest modification. The TGA can combine test coverage from different origins (e.g., manual tests and unit tests). The start date after which code modifications are considered is called ”Baseline” and is an important parameter of each TGA inspection.</p><h2 id="test-gap-badge" tabindex="-1">Test Gap Badge <a class="header-anchor" href="#test-gap-badge" aria-label="Permalink to &quot;Test Gap Badge&quot;">​</a></h2><p>The Test Gap Badge is the visual representation of test gap data which is often added to merge requests by Teamscale.</p><p><img src="'+s+'" alt="Test Gap Badge" width="160" height="13"></p><p>The Test Gap badge can be read as follows:</p><ul><li>Ratio: The <a href="#test-gap-ratio">Test Gap Ratio</a>.</li><li>Green: Number of changed and added methods which have been tested.</li><li>Yellow: Number of changed methods which have not been tested.</li><li>Red: Number of added methods which have not been tested.</li></ul><h2 id="test-gap-ratio" tabindex="-1">Test Gap Ratio <a class="header-anchor" href="#test-gap-ratio" aria-label="Permalink to &quot;Test Gap Ratio&quot;">​</a></h2><p>This metric denotes the number of modified or new methods not covered by tests divided by the total number of modified or new methods.</p><h2 id="test-impact-analysis" tabindex="-1">Test Impact Analysis <a class="header-anchor" href="#test-impact-analysis" aria-label="Permalink to &quot;Test Impact Analysis&quot;">​</a></h2><p>The Test Impact Analysis (TIA) can select and prioritize regression tests given a concrete changeset. The TIA uses Testwise Coverage for the test selection. Test covering the given changes are called impacted tests.</p><h2 id="testwise-coverage" tabindex="-1">Testwise Coverage <a class="header-anchor" href="#testwise-coverage" aria-label="Permalink to &quot;Testwise Coverage&quot;">​</a></h2><p>Testwise Coverage is the name of a report format based on JSON. It contains a list of tests contained in the set of all available tests, as well as optional coverage per test and execution results of the test.</p><h2 id="threshold" tabindex="-1">Threshold <a class="header-anchor" href="#threshold" aria-label="Permalink to &quot;Threshold&quot;">​</a></h2><p>A threshold can be used to derive findings from metrics. For example, the metric »File Size« has two thresholds, set to 300 (yellow) and 750 (red) as default. Hence, files which are longer than 300 SLOC, become a yellow finding. Files longer than 750 SLOC become a red finding.</p><h2 id="threshold-configuration" tabindex="-1">Threshold Configuration <a class="header-anchor" href="#threshold-configuration" aria-label="Permalink to &quot;Threshold Configuration&quot;">​</a></h2><p>A threshold configuration comprises a set of thresholds for the analyses.</p><h2 id="timetravel" tabindex="-1">Timetravel <a class="header-anchor" href="#timetravel" aria-label="Permalink to &quot;Timetravel&quot;">​</a></h2><p>The timetravel is a feature of Teamscale which makes it possible to show all of Teamscale’s content in a historized form, i.e., to display all information at any point in time of the project’s history.</p><h2 id="tolerated-finding" tabindex="-1">Tolerated Finding <a class="header-anchor" href="#tolerated-finding" aria-label="Permalink to &quot;Tolerated Finding&quot;">​</a></h2><p>A tolerated finding denotes a finding which is technically correct, but has been tolerated as it cannot or should not be fixed, e.g., because the detected issue is not relevant or its resolution requires unjustifiably high efforts. To tolerate a finding means that this finding will be put in the tolerated findings section and not shown directly anymore. In the Code Detail View or in the IDE integration, it will be not shown at all. It can, however, still be inspected in the Tolerated Findings View.</p><h2 id="treemap" tabindex="-1">Treemap <a class="header-anchor" href="#treemap" aria-label="Permalink to &quot;Treemap&quot;">​</a></h2><p>Treemaps visualize individual metrics in relation to the source code structure and file sizes. Therefore, directories or source code files of the analyzed system are drawn as rectangles. The area of the rectangle corresponds to the number of lines contained in the file (or for directories all the files included in the directory). The position of the rectangle follows the directory structure, i.e., rectangles for files in the same directory are drawn next to each other. The shading of the rectangles indicates the hierarchical nesting of the files and directories.</p><h2 id="trend" tabindex="-1">Trend <a class="header-anchor" href="#trend" aria-label="Permalink to &quot;Trend&quot;">​</a></h2><p>A trend indicates the evolution of a metric over time. A trend can be calculated for both a numeric metric and an assessment metric. In this first case, the trend is just a simple function in the mathematical sense. In the second case, the trend chart indicates three values per time: the green, the yellow, and the red value and shows how the system distribution over these three categories evolves. If branch support is disabled, the history of the system and, hence, a metric trend, is linear by default. If branch support is enabled, however, the history of a branch is not necessarily linear. To display a linear trend, the »first-parent« strategy is used to pick one parent for each commit.</p><h2 id="type-dependency" tabindex="-1">Type Dependency <a class="header-anchor" href="#type-dependency" aria-label="Permalink to &quot;Type Dependency&quot;">​</a></h2><p>In a type-based architecture, the full-qualified names of all types (classes, structs, enums etc.) in the codebase are used for dependencies.</p><h2 id="uniform-path" tabindex="-1">Uniform Path <a class="header-anchor" href="#uniform-path" aria-label="Permalink to &quot;Uniform Path&quot;">​</a></h2><p>File-path-like string that represents a hierarchy. These paths are used to represent all hierarchically structured data in Teamscale e.g. source file locations or test names. Parts of the hierarchy are delimited by forward slashes.</p><p>Example: <code>com/example/MyTest/testSomething</code>.</p><h2 id="view" tabindex="-1">View <a class="header-anchor" href="#view" aria-label="Permalink to &quot;View&quot;">​</a></h2><p>A view is a UI element of Teamscale’s web interface. In contrast to pages, it cannot be references by the sidebar but appears and disappears as the user navigates and performs certain tasks.</p><h2 id="violation" tabindex="-1">Violation <a class="header-anchor" href="#violation" aria-label="Permalink to &quot;Violation&quot;">​</a></h2><p>If a dependency contradicts a modeled policy, it will be treated as an architecture violation.</p><h2 id="voting" tabindex="-1">Voting <a class="header-anchor" href="#voting" aria-label="Permalink to &quot;Voting&quot;">​</a></h2><p>For many code collaboration platforms (e.g., GitHub, GitLab, Bitbucket), Teamscale supports voting. The semantics are slightly different depending on the platform, but in general this is the process of adding a vote to a merge request. This can be a &quot;thumbs up&quot;, &quot;+1&quot;, or simply a passing build result. In addition to this, Teamscale can also integrate information such as the number of findings, relevant <a href="#test-gap">test gaps</a> or similar to the merge requests, this is usually done by enhancing the merge request&#39;s description. Last but not least, Teamscale may also add detailed line comments to merge requests, which show relevant findings at the relevant code lines.</p>',174)])])}const g=a(r,[["render",l]]);export{f as __pageData,g as default};
