import{_ as o,c as i,ak as s,b as e,O as a,L as r,o as l}from"./chunks/framework.D4LivsWb.js";const w=JSON.parse('{"title":"Software Intelligence Vision","description":"","frontmatter":{},"headers":[],"relativePath":"introduction/software-intelligence-vision/index.md","filePath":"introduction/software-intelligence-vision/index.md"}'),c={name:"introduction/software-intelligence-vision/index.md"};function u(d,n,h,f,p,g){const t=r("PdfDownload");return l(),i("div",null,[n[0]||(n[0]=s('<h1 id="software-intelligence-vision" tabindex="-1">Software Intelligence Vision <a class="header-anchor" href="#software-intelligence-vision" aria-label="Permalink to &quot;Software Intelligence Vision&quot;">​</a></h1><p>Ultimately, any software strives to satisfy their users to maximize profit. However, user needs evolve - they change, they expand. Additionally, not only the market situation changes, but also the underlying technology and hardware evolves. Developing software in such agile environments is a challenge: Being able to keep up is not trivial. And it heavily depends on the quality of the software.</p><p>To lead a software project to long-term success, software engineers are facing various decisions. From choosing the right underlying hardware and technology to prioritizing which features to implement, decisions have to be made daily. While facilitating continuous software change, managers and developers also have to consider the following: How long will our code base still be maintainable? Is our software sufficiently tested? Does our architecture satisfy current and future requirements? Those decisions are fundamental and have potentially long-term impact on the success (or failure) of the project.</p><p>For all these questions, intuition and often prominent gut-feelings are bad decision criteria. Instead, decisions should much rather be made based on solid data from the specific project. Yet, even though the data is technically available, it often remains unused because the data is implicit, hard to extract, hard to visualize or not trivial to interpret. For a profound decision making in software engineering, <em>Software Intelligence</em> is required: Just as business intelligence provides a &quot;set of techniques and tools for the transformation of raw data into meaningful and useful information for business analysis purposes&quot; <a href="https://en.wikipedia.org/wiki/Business_intelligence" target="_blank" rel="noreferrer">Wikipedia</a>, software intelligence targets the same purpose: Software intelligence uses data mining to provide a solid foundation for decision making in software development.</p><p>Today, Teamscale is the only Software Intelligence Platform on the market. With Teamscale, you can steer the success of your project based on solid and profound data from your software: Integrating various sources such as code repositories, architecture documentations, test executions, issue trackers and runtime execution in production, Teamscale provides you transparent answers to the following questions:</p><ul><li><strong>Code Quality</strong>: <a href="./../../tutorial/getting-quality-overview/">Do we have more spaghetti code than clean code?</a></li><li><strong>Test Quality</strong>: <a href="./../../introduction/improving-test-quality/">Did we actually test what we changed or did we miss something?</a></li><li><strong>Test Efficiency</strong>: <a href="./../../tutorial/improving-test-efficiency/">How can we speed up our existing tests?</a></li><li><strong>Architecture Quality</strong>: <a href="./../../reference/ui/architecture/">Does our code still match our architecture?</a></li><li><strong>Feature Management</strong>: <a href="./../../introduction/improving-software-quality/#analyzing-feature-usage">Is all of our code in fact used by the users?</a></li></ul><p>Being able to control these aspects makes your project more likely to succeed - and also more fun to work in. Teamscale will signal red flags early enough when tempting feature pressure deteriorates your software quality. Small quality deviations can be often redeemed quickly when developers discover them early. But at some point, consequences of failing to do so become unbearable. This is not something we just make up. We all have seen software that needed to be rewritten. Also research has shown that software quality - wrt. to code, test, and architecture - gradually decays over time if no effective counter measures are taken <a href="#quality-papers">[1 - 5]</a>. So do something before it is too late! And don&#39;t waste money for maintaining code that is not even executed by the user. Even though it seems as this code just sits there at no further cost, do not underestimate the effort which this unused code creates for maintenance <a href="#paper-unused-code">[6]</a>.</p><p>To make your project a success, Teamscale offers a broad range of prospects. It adequately addresses your needs and provides appropriate views of your software&#39;s quality regardless of whether you are a developer, a tester, an architect, a product owner or a manager. It adapts flexibly to your chosen development process and also supports feature-branch driven development. In contrast to many existing tools, it does not only analyze the main development trunk, but can be tailored to every single branch.</p><p>Further, Teamscale can handle common programming languages such as Java, Javascript, C or C++, but also knows how to deal with a bit more exotic languages such as ABAP, Ada, Delphi, Python or PL/SQL - just to name a few. It also integrates with most common infrastructures such as Subversion, Git or TFS on the version control side or Jira, Azure DevOps Boards (TFS), and RTC/Jazz on the issue tracking side. For an up-to-date and complete list of Teamscale&#39;s capabilities, please also refer to our website <a href="https://teamscale.com" target="_blank" rel="noreferrer">www.teamscale.com</a>.</p><hr><h4 id="further-reading" tabindex="-1">Further Reading: <a class="header-anchor" href="#further-reading" aria-label="Permalink to &quot;Further Reading:&quot;">​</a></h4>',11)),e("ol",null,[e("li",null,[a(t,{id:"quality-papers",title:"Did We Test Our Changes? Assessing Alignment between Tests and Development in Practice",subtitle:"S. Eder, B. Hauptmann, M. Junker, E. Juergens, R. Vaas, and K-H. Prommer.",link:"https://www.cqse.eu/publications/2013-did-we-test-our-changes-assessing-alignment-between-tests-and-development-in-practice.pdf"})]),e("li",null,[a(t,{title:"Does Code Decay? Assessing the Evidence from Change Management Data",subtitle:"Stephen G. Eick, Todd L. Graves, Alan F. Karr, J. S. Marron, and Audris Mockus, In: IEEE Software. 2001",link:"http://mockus.us/papers/decay.pdf"})]),e("li",null,[a(t,{title:"The loss of architectural knowledge during system evolution: An industrial case study",subtitle:"M. Feilkas, D. Ratiu, and E. Jürgens,  In: Proceedings of the 17th IEEE International Conference on Program Comprehension (ICPC’09). 2009",link:"https://wwwbroy.in.tum.de/publ/papers/2009_icpc_feilkas.pdf"})]),e("li",null,[a(t,{title:"Software aging",subtitle:"David Lorge Parnas, In: Proceedings of the 16th International Conference of Software Engineering (ICSE). 1994",link:"https://www.cs.drexel.edu/~yfcai/CS451/RequiredReadings/SoftwareAging.pdf"})]),e("li",null,[a(t,{title:"Continuous Software Quality Control in Practice",subtitle:"D. Steidl, F. Deissenboeck, M. Poehlmann, R. Heinke, and B. Uhink-Mergenthaler,  In: Proceedings of the IEEE International Conference on Software Maintenance and Evolution (ICSME). 2014",link:"https://www.cqse.eu/publications/2014-continuous-software-quality-control-in-practice.pdf"})]),e("li",null,[a(t,{id:"paper-unused-code",title:"How much does unused code matter for maintenance?",subtitle:"S. Eder, M. Junker, E. Jürgens, B. Hauptmann, R. Vaas, and K.-H. Prommer,  In: Proceedings of the 34th International Conference on Software Engineering (ICSE 12). 2012",link:"https://www.cqse.eu/publications/2012-how-much-does-unused-code-matter-for-maintenance.pdf"})])])])}const y=o(c,[["render",u]]);export{w as __pageData,y as default};
