import{_ as t,c as a,ak as o,o as r}from"./chunks/framework.D4LivsWb.js";const i="/assets/references-in-code.CtYCuv-L.png",s="/assets/project-creation.BxuTULL8.png",n="/assets/git-credentials.DOxvHz5_.png",c="/assets/polarion-credentials.gkTGEtqt.png",m="/assets/polarion-connector.BczG3iNx.png",p="/assets/spec-item-list.B21nKpi5.png",h="/assets/code-reference-matrix.ChgTeU0m.png",l="/assets/open-spec-items.DJr-uf7e.png",d="/assets/spec-item-widget.rKbo7qn-.png",u="/assets/links-to-items.Dau-fOOU.png",T=JSON.parse('{"title":"Setting up Requirements Tracing Analysis","description":"","frontmatter":{},"headers":[],"relativePath":"tutorial/setting-up-requirements-tracing/index.md","filePath":"tutorial/setting-up-requirements-tracing/index.md"}'),g={name:"tutorial/setting-up-requirements-tracing/index.md"};function f(w,e,q,y,_,k){return r(),a("div",null,[...e[0]||(e[0]=[o('<h1 id="setting-up-requirements-tracing-analysis" tabindex="-1">Setting up Requirements Tracing Analysis <a class="header-anchor" href="#setting-up-requirements-tracing-analysis" aria-label="Permalink to &quot;Setting up Requirements Tracing Analysis&quot;">​</a></h1><p>As a person responsible for making sure that safety-critical requirements are correctly implemented and tested in your software system, you may want to use the <a href="./../../glossary/#requirements-tracing">Requirements Tracing</a> features of Teamscale to support you. This tutorial leads you through the setup of major requirement tracing features available in Teamscale and consists of the following parts:</p><nav class="table-of-contents"><ul><li><a href="#step-1-preparing-the-source-code-for-analysis">Step 1: Preparing the source code for analysis</a></li><li><a href="#step-2-setting-up-a-teamscale-project-with-a-requirements-management-tool-connector">Step 2: Setting up a Teamscale project with a Requirements Management Tool connector</a></li><li><a href="#step-3-getting-to-know-the-requirements-tracing-perspective">Step 3: Getting to know the Requirements Tracing Perspective</a></li><li><a href="#step-4-using-spec-item-metrics-in-dashboards">Step 4: Using spec item metrics in Dashboards</a></li><li><a href="#step-5-linking-the-references-in-source-code-to-the-spec-items-from-your-requirements-management-tool">Step 5: Linking the references in source code to the spec items from your requirements management tool</a></li></ul></nav><h2 id="step-1-preparing-the-source-code-for-analysis" tabindex="-1">Step 1: Preparing the source code for analysis <a class="header-anchor" href="#step-1-preparing-the-source-code-for-analysis" aria-label="Permalink to &quot;Step 1: Preparing the source code for analysis&quot;">​</a></h2><p>Clone the GitHub repository <a href="https://github.com/TheAlgorithms/C" target="_blank" rel="noreferrer">The Algorithms - C</a>. This is an open source implementation of common computer science algorithms in the C language. We will use it as an example of a safety-critical system under development. Navigate to <code>data_structures/stack/stack.c</code> file of the repository and add a couple of source code comments that reference <a href="./../../glossary/#specification-item">spec items</a>, as shown in the image below. Let us assume that all the spec items in your requirements management tool adhere to the naming scheme <code>DP-(\\d+)</code>, e.g., <code>DP-123</code>. Adding the references to source code comments allows Teamscale to establish links between the code entities (methods, classes, etc.) and the corresponding items imported from the requirements management tool.</p><p><img src="'+i+'" alt="Add spec item references to source code" width="573" height="436"></p><p>Commit your changes.</p><h2 id="step-2-setting-up-a-teamscale-project-with-a-requirements-management-tool-connector" tabindex="-1">Step 2: Setting up a Teamscale project with a Requirements Management Tool connector <a class="header-anchor" href="#step-2-setting-up-a-teamscale-project-with-a-requirements-management-tool-connector" aria-label="Permalink to &quot;Step 2: Setting up a Teamscale project with a Requirements Management Tool connector&quot;">​</a></h2><p>As a prerequisite for this step, create a free test account in the <a href="https://almdemo.polarion.com/polarion" target="_blank" rel="noreferrer">public Polarion instance</a>. We will use the <a href="https://almdemo.polarion.com/polarion/#/project/drivepilot/wiki/Requirements/System%20Requirement%20Specification" target="_blank" rel="noreferrer">System Requirement Specification</a> of the <a href="https://almdemo.polarion.com/polarion/#/project/drivepilot?shortcut=favorites%2FHome" target="_blank" rel="noreferrer">drivepilot</a> project as an example of a requirements specification for a safety-critical software system under development.</p><p>In Teamscale, go to <em>Project Configuration</em> and click <em>New project</em>.</p><p>Name the new project <code>Requirements Tracing Test</code> and choose the analysis profile <em>C/C++ Default</em>.</p><p><img src="'+s+'" alt="Create the project" width="784" height="342" data-zoom="true"></p><p>Click <em>Source Code Repository</em> and select <em>Git</em>. Create a new account named <code>Git</code> and point it to your local copy of the repository that we have modified in Step 1. Leave the rest of the options unchanged.</p><p><img src="'+n+'" alt="Create Git credentials" width="1456" height="432" data-zoom="true"></p><p>Click <em>Requirements Management Tools</em> and select <em>Polarion</em>. After that, point the Teamscale connector to the Polarion account you have created using the <code>https://almdemo.polarion.com/</code> URL and your username and password.</p><p><img src="'+c+'" alt="Create Polarion credentials" width="1452" height="430" data-zoom="true"></p><p>Configure the connector as shown in the image below.</p><p><img src="'+m+'" alt="Configure Polarion connector" width="889" height="680" data-zoom="true"></p><p>Note that we need to provide Teamscale with a way to identify the work items that belong to the Teamscale project. This is done via the <em>Spec item ID pattern</em> option. This is the reason why we have provided the source code comments of the shape <code>DP-{\\d+}</code> - the example <a href="https://almdemo.polarion.com/polarion/#/project/drivepilot?shortcut=favorites%2FHome" target="_blank" rel="noreferrer">drivepilot</a> project in the <a href="https://almdemo.polarion.com/polarion" target="_blank" rel="noreferrer">Polarion</a> instance uses this naming schema for the work items.</p><p>Click <em>Create Project</em>.</p><h2 id="step-3-getting-to-know-the-requirements-tracing-perspective" tabindex="-1">Step 3: Getting to know the Requirements Tracing Perspective <a class="header-anchor" href="#step-3-getting-to-know-the-requirements-tracing-perspective" aria-label="Permalink to &quot;Step 3: Getting to know the Requirements Tracing Perspective&quot;">​</a></h2><p>Navigate to the <em>Requirements Tracing</em> Perspective in Teamscale and view the spec items.</p><p><img src="'+p+'" alt="View the imported spec items" width="1637" height="838" data-zoom="true"></p><p>The code reference matrix in the next tab tells you exactly which spec item is referenced by which method/class in the source code.</p><p><img src="'+h+'" alt="Code reference matrix" width="1374" height="307" data-zoom="true"></p><h2 id="step-4-using-spec-item-metrics-in-dashboards" tabindex="-1">Step 4: Using spec item metrics in Dashboards <a class="header-anchor" href="#step-4-using-spec-item-metrics-in-dashboards" aria-label="Permalink to &quot;Step 4: Using spec item metrics in Dashboards&quot;">​</a></h2><p>Create and save a spec item query. In the image below, the query is <code>status=Open</code>, which means it selects all the spec items in status <code>Open</code>.</p><p><img src="'+l+'" alt="Query for open spec items" width="1749" height="743" data-zoom="true"></p><p>Navigate to the <em>Dashboards</em> perspective and create a metric widget, such as the numeric metric widget in the example below. Select <code>requirements-tracing-test/-spec-items-/requirements/open</code> as <em>Path</em> and <em>Spec Items</em> as <em>Metric</em> in the widget configuration. The example widget shows the count of requirement items in the state <code>Open</code>.</p><p><img src="'+d+'" alt="Use a spec item metric in a dashboard widget" width="843" height="534" data-zoom="true"></p><h2 id="step-5-linking-the-references-in-source-code-to-the-spec-items-from-your-requirements-management-tool" tabindex="-1">Step 5: Linking the references in source code to the spec items from your requirements management tool <a class="header-anchor" href="#step-5-linking-the-references-in-source-code-to-the-spec-items-from-your-requirements-management-tool" aria-label="Permalink to &quot;Step 5: Linking the references in source code to the spec items from your requirements management tool&quot;">​</a></h2><p>Navigate to the <em>Metrics/Files</em> View of Teamscale and then to the <code>data_structures/stack/stack.s</code> file. View how the spec item references you have provided in the source code in Step 1 have been linked to the spec items from your requirements management tool.</p><p><img src="'+u+'" alt="See links in code and items from the tracker in one place" width="1120" height="620" data-zoom="true"></p>',33)])])}const v=t(g,[["render",f]]);export{T as __pageData,v as default};
