# Description
Checks for extra spaces before dots at the ends of statements.

# Extended Information
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#be-consistent
https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#condense-your-code

# Examples
**Bad example**
```abap
WRITE bar .
```

**Good example**
```abap
WRITE bar.
```

# Clean ABAP Code Style Guide
Format all code of a project in the same way.
Let all team members use the same formatting style.

If you edit foreign code, adhere to that project's formatting style
instead of insisting on your personal style.

If you change your formatting rules over time,
use [refactoring best practices](https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#how-to-refactor-legacy-code)
to update your code over time.

---
For more information visit the [official ABAPLint rule documentation](https://rules.abaplint.org/space_before_dot) <br>
The contents within section `Clean ABAP Code Style Guide` were copied from the [official SAP Code Style Guides repository](https://github.com/SAP/styleguides/).
