POSIX based operating systems utilize a permissions model to protect access to
parts of the file system. This model supports three roles "owner", "group"
and "world" each role may have a combination of "read", "write" or "execute"
flags sets. Python provides ``chmod`` to manipulate POSIX style permissions.

This plugin test looks for the use of ``chmod`` and will alert when it is used
to set particularly permissive control flags. A MEDIUM warning is generated if
a file is set to group write or executable and a HIGH warning is reported if a
file is set world write or executable. Warnings are given with HIGH confidence.

## Example


In the following code snippet the issue is: Probable insecure usage of temp file/directory.
For more information on this see: CWE-732 (https://cwe.mitre.org/data/definitions/732.html)
``` python
 os.chmod('/etc/hosts', 0o777)
 os.chmod('/tmp/oh_hai', 0x1ff)
 os.chmod('/etc/passwd', stat.S_IRWXU)
```
In the following code snippet the issue is: Chmod setting a permissive mask 0777 on file (key_file).
For more information on this see: CWE-732 (https://cwe.mitre.org/data/definitions/732.html)
``` python
 os.chmod('/etc/passwd', stat.S_IRWXU)
 os.chmod(key_file, 0o777)

```
## see also:

- https://security.openstack.org/guidelines/dg_apply-restrictive-file-permissions.html
- https://en.wikipedia.org/wiki/File_system_permissions
- https://security.openstack.org
- https://cwe.mitre.org/data/definitions/732.html

New in version  0.9.0

Changed in version  1.7.3
CWE information added

Changed in version  1.7.5
Added checks for S_IWGRP and S_IXOTH
