This plugin test checks for the unsafe usage of the ``yaml.load`` function from
the PyYAML package. The yaml.load function provides the ability to construct
an arbitrary Python object, which may be dangerous if you receive a YAML
document from an untrusted source. The function yaml.safe_load limits this
ability to simple Python objects like integers or lists.

Please see
https://pyyaml.org/wiki/PyYAMLDocumentation#LoadingYAML for more information
on ``yaml.load`` and yaml.safe_load

## Example


In the following code snippet the issue is: [yaml_load] Use of unsafe yaml load. Allows instantiation of
arbitrary objects. Consider yaml.safe_load().
For more information on this see: CWE-20 (https://cwe.mitre.org/data/definitions/20.html)
``` python
ystr = yaml.dump({'a' : 1, 'b' : 2, 'c' : 3})
y = yaml.load(ystr)
yaml.dump(y)
```
## see also:

- https://pyyaml.org/wiki/PyYAMLDocumentation#LoadingYAML
- https://cwe.mitre.org/data/definitions/20.html

New in version  1.0.0

Changed in version  1.7.3
CWE information added
