## Number of Public Attributes Check

### What is the intent of the check?

This check counts the number of public attributes and ABAP objects and reports a finding when it exceeds a configurable threshold. All attributes should be private (by default) or protected (if needed). The [data encapsulation principle](https://en.wikipedia.org/wiki/Encapsulation_(computer_programming)) helps you to protect your attributes from being changed and adds readability for others; the basic principle is that [one only sees what is needed](https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#members-private-by-default-protected-only-if-needed).

### How does the check work?

This check counts only `DATA` and `CLASS-DATA` statements within the public section of a global or local class definition or interface definition. Inherited attributes and constants are not counted as attributes for the purpose of this check. A structure is counted as one attribute, no matter how many components are in the structure.

### How to solve the issue?

Make all attributes private or protected. You can grant read access with getter methods and write access with setter methods instead. For immutable attributes, [consider using `READ-ONLY` public attributes](https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#consider-using-immutable-instead-of-getter).

### What to do in case of exception?

In exceptional cases, you can suppress this finding by using the pseudo comment `"#EC NUM_PUBLIC_ATTR` which should be placed right after the `PUBLIC SECTION` statement.

Note that this check is equivalent to a subset of the "OO Size Metrics" check delivered by SAP. That check accepts no pseudo comments or pragmas. We recommend that you *either* use this Code Pal check *or* the SAP-delivered check, but not both, since if you use both you get two findings for the exact same issue.

```abap
CLASS class_name DEFINITION.  
  PUBLIC SECTION. "#EC NUM_PUBLIC_ATTR
    DATA attribute1 TYPE i.
    DATA attribute2 TYPE i.
ENDCLASS.
```

### Further Reading
* [Clean ABAP - Private by default](https://github.com/SAP/styleguides/blob/main/clean-abap/CleanABAP.md#members-private-by-default-protected-only-if-needed) 
* [Code Pal for ABAP Documentation](https://github.com/SAP/code-pal-for-abap/blob/master/docs/checks/number-public-attributes.md)