Variables named `I`, `O`, and `l` can be very hard to read. This is because the letter `I` and the letter `l` are easily confused, and the letter `O` and the number `0` can be easily confused.

Change the names of these variables to something more descriptive.

### Anti-pattern

The code in this example could be misinterpreted to be `0 * 1.08` (zero times one-point-eight).

```python
O = 100.0
total = O * 1.08
```

### Best practice

This example clarifies that we're multiplying an `order` variable by another number.

```python
order = 100.0
total = order * 1.08
```
