### SCS0011 - Unsafe XSLT setting used 

XSLT scripting should be enabled only if you require script support and you are working in a fully trusted environment.

#### Risk

This issue may lead to Remote Code Execution (RCE) if the XML source is untrusted.

#### Vulnerable Code

```cs
XslCompiledTransform transform = new XslCompiledTransform();
XsltSettings settings = new XsltSettings() {EnableScript = true};
transform.Load(xslPath, settings, null);
// Execute the transformation.
transform.Transform(reader, writer);

```

#### References

[CWE-611: Improper Restriction of XML External Entity Reference](https://cwe.mitre.org/data/definitions/611.html)  
[XSLT Server Side Injection Attacks](https://www.contextis.com/us/blog/xslt-server-side-injection-attacks)  
[XML Attack for C# Remote Code Execution](https://zerosum0x0.blogspot.com/2016/05/xml-attack-for-c-remote-code-execution.html)  
[XsltSettings.EnableScript Property](https://docs.microsoft.com/en-us/dotnet/api/system.xml.xsl.xsltsettings.enablescript?view=net-5.0)

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)