<h2>Why is this an issue?</h2>
<p>The complexity of an expression is defined by the number of <code>&amp;&amp;</code>, <code>||</code> and <code>condition ? ifTrue : ifFalse</code>
operators it contains.</p>
<p>A single expression’s complexity should not become too high to keep the code readable.</p>
<h3>Noncompliant code example</h3>
<p>With the default threshold value of 3</p>
<pre>
if (((condition1 &amp;&amp; condition2) || (condition3 &amp;&amp; condition4)) &amp;&amp; condition5) { ... }
</pre>
<h3>Compliant solution</h3>
<pre>
if ((MyFirstCondition() || MySecondCondition()) &amp;&amp; MyLastCondition()) { ... }
</pre>

