<h2>Why is this an issue?</h2>
<p><code>NotImplementedException</code> is often used to mark methods which must be implemented for the overall functionality to be complete, but
which the developer wants to implement later. That’s as opposed to the <code>NotSupportedException</code> which is thrown by methods which are
required by base classes or interfaces, but which are not appropriate to the current class.</p>
<p>This rule raises an exception when <code>NotImplementedException</code> is thrown.</p>
<h3>Noncompliant code example</h3>
<pre>
void doTheThing()
{
    throw new NotImplementedException();
}
</pre>
<h3>Exceptions</h3>
<p>Exceptions derived from <code>NotImplementedException</code> are ignored.</p>

