<h2>Why is this an issue?</h2>
<p>Some constructors of the <code>ArgumentException</code>, <code>ArgumentNullException</code>, <code>ArgumentOutOfRangeException</code> and
<code>DuplicateWaitObjectException</code> classes must be fed with a valid parameter name. This rule raises an issue in two cases:</p>
<ul>
  <li> When this parameter name doesn’t match any existing ones. </li>
  <li> When a call is made to the default (parameterless) constructor </li>
</ul>
<h3>Noncompliant code example</h3>
<pre>
public void Foo(Bar a, int[] b)
{
  throw new ArgumentException();                                        // Noncompliant
  throw new ArgumentException("My error message", "c");                 // Noncompliant
  throw new ArgumentException("My error message", "c", innerException); // Noncompliant

  throw new ArgumentNullException("c");                     // Noncompliant
  throw new ArgumentNullException(nameof(c));               // Noncompliant
  throw new ArgumentNullException("My error message", "a"); // Noncompliant

  throw new ArgumentOutOfRangeException("c");                           // Noncompliant
  throw new ArgumentOutOfRangeException("c", "My error message");       // Noncompliant
  throw new ArgumentOutOfRangeException("c", b, "My error message");    // Noncompliant

  throw new DuplicateWaitObjectException("c", "My error message");      // Noncompliant
}
</pre>
<h3>Compliant solution</h3>
<pre>
public void Foo(Bar a, int[] b)
{
  throw new ArgumentException("My error message", "a");
  throw new ArgumentException("My error message", "b", innerException);

  throw new ArgumentNullException("a");
  throw new ArgumentNullException(nameof(a));
  throw new ArgumentNullException("a", "My error message");

  throw new ArgumentOutOfRangeException("b");
  throw new ArgumentOutOfRangeException("b", "My error message");
  throw new ArgumentOutOfRangeException("b", b, "My error message");

  throw new DuplicateWaitObjectException("b", "My error message");
}
</pre>
<h3>Exceptions</h3>
<p>The rule won’t raise an issue if the parameter name is not a constant value.</p>

