﻿## SA1006

<table>
<tr>
  <td>TypeName</td>
  <td>SA1006PreprocessorKeywordsMustNotBePrecededBySpace</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1006</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

A C# preprocessor-type keyword is preceded by space.

## Rule description

A violation of this rule occurs when the preprocessor-type keyword in a preprocessor directive is preceded by space. For example:

```csharp
# if Debug
```

There should not be any whitespace between the opening hash mark and the preprocessor-type keyword:

```csharp
#if Debug
```

## How to fix violations

To fix a violation of this rule, ensure that there is no whitespace between the opening hash mark and the preprocessor-type keyword.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1006:PreprocessorKeywordsMustNotBePrecededBySpace", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1006 // PreprocessorKeywordsMustNotBePrecededBySpace
#pragma warning restore SA1006 // PreprocessorKeywordsMustNotBePrecededBySpace
```
