﻿## SA1515

<table>
<tr>
  <td>TypeName</td>
  <td>SA1515SingleLineCommentMustBePrecededByBlankLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1515</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

A single-line comment within C# code is not preceded by a blank line.

## Rule description

To improve the readability of the code, StyleCop requires blank lines in certain situations, and prohibits blank lines
in other situations. This results in a consistent visual pattern across the code, which can improve recognition and
readability of unfamiliar code.

A violation of this rule occurs when a single-line comment is not preceded by a blank line. For example:

```csharp
public bool Enabled
{
    get 
    {
        Console.WriteLine("Getting the enabled flag.");
        // Return the value of the 'enabled' field.
        return this.enabled;  
    }
}
```

The code above would generate an instance of this violation, since the single-line comment is not preceded by a blank
line.

An exception to this rule occurs when the single-line comment is the first item within its scope. In this case, the
comment should not be preceded by a blank line. For example:

```csharp
public bool Enabled
{
    get 
    {
        // Return the value of the 'enabled' field.
        return this.enabled;  
    }
}
```

In the code above, the comment is the first item within its scope, and thus it should not be preceded by a blank line.

If the comment is being used to comment out a line of code, begin the comment with four forward slashes rather than two.
This will cause StyleCop to ignore this violation. For example:

```csharp
public bool Enabled
{
    get 
    {
        Console.WriteLine("Getting the enabled flag.");
        ////return false;
        return this.enabled;  
    }
}
```

## How to fix violations

To fix a violation of this rule, add a blank line above the comment.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1515:SingleLineCommentMustBePrecededByBlankLine", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1515 // SingleLineCommentMustBePrecededByBlankLine
#pragma warning restore SA1515 // SingleLineCommentMustBePrecededByBlankLine
```
