﻿## SA1607

<table>
<tr>
  <td>TypeName</td>
  <td>SA1607PartialElementDocumentationMustHaveSummaryText</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1607</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

## Cause

The `<summary>` or `<content>` tag within the documentation header for a C# code element is empty.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs when the documentation header for a partial element (an element with the partial attribute) contains an empty `<summary>` tag or `<content>` tag which does not contain a description of the element. In C# the following types of elements can be attributed with the partial attribute: classes, methods.

When documentation is provided on more than one part of the partial class, the documentation for the two classes may be merged together to form a single source of documentation. For example, consider the following two parts of a partial class:

```csharp
/// <summary>
/// Documentation for the first part of Class1.
/// </summary>
public partial class Class1
{
}

/// <summary>
/// Documentation for the second part of Class1.
/// </summary>
public partial class Class1
{
}
```

These two different parts of the same partial class each provide different documentation for the class. When the documentation for this class is built into an SDK, the tool building the documentation will either choose to use only one part of the documentation for the class and ignore the other parts, or, in some cases, it may merge the two sources of documentation together, to form a string like: "Documentation for the first part of Class1. Documentation for the second part of Class1."

For these reasons, it can be problematic to provide SDK documentation on more than one part of the partial class. However, it is still advisable to document each part of the class, to increase the readability and maintainability of the code, and StyleCop will require that each part of the class contain header documentation.

This problem is solved through the use of the `<content>` tag, which can replace the `<summary>` tag for partial classes. The recommended practice for documenting partial classes is to provide the official SDK documentation for the class on the main part of the partial class. This documentation should be written using the standard `<summary>` tag. All other parts of the partial class should omit the `<summary>` tag completely, and replace it with a `<content>` tag. This allows the developer to document all parts of the partial class while still centralizing all of the official SDK documentation for the class onto one part of the class. The `<content>` tags will be ignored by the SDK documentation tools.

## How to fix violations

To fix a violation of this rule, fill-in the contents of the summary tag or content tag with a description of the code element.

The following example shows a method which contains an empty `<summary>` tag.

```csharp
/// <summary>  </summary>
/// <param name="customerId">The ID of the customer to find.</param>
/// <returns>The customer, or null if the customer could not be found.</returns>
public Customer FindCustomer(int customerId)
{
    // ... finds the customer ...
}
```

To fix the violation, add valid summary text. For example: 

```csharp
/// <summary>Attempts to locate a record for the customer with the given ID.</summary>
/// <param name="customerId">The ID of the customer to find.</param>
/// <returns>The customer, or null if the customer could not be found.</returns>
public Customer FindCustomer(int customerId)
{
    // ... finds the customer ...
}
```

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1607:PartialElementDocumentationMustHaveSummaryText", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1607 // PartialElementDocumentationMustHaveSummaryText
#pragma warning restore SA1607 // PartialElementDocumentationMustHaveSummaryText
```
