<h2>Why is this an issue?</h2>
<p>Unnecessary imports refer to importing types that are not used or referenced anywhere in the code.</p>
<p>Although they don’t affect the runtime behavior of the application after compilation, removing them will:</p>
<ul>
  <li> Improve the readability and maintainability of the code. </li>
  <li> Help avoid potential naming conflicts. </li>
  <li> Improve the build time, as the compiler has fewer lines to read and fewer types to resolve. </li>
  <li> Reduce the number of items the code editor will show for auto-completion, thereby showing fewer irrelevant suggestions. </li>
</ul>
<h3>Exceptions</h3>
<p>Imports for types mentioned in Javadocs are ignored.</p>
<h2>How to fix it</h2>
<p>While it’s not difficult to remove these unneeded lines manually, modern code editors support the removal of every unnecessary import with a single
click from every file of the project.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
package myapp.helpers;

import java.io.IOException;
import java.nio.file.*;
import java.nio.file.*;     // Noncompliant - package is imported twice
import java.lang.Runnable;  // Noncompliant - java.lang is imported by default

public class FileHelper {
    public static String readFirstLine(String filePath) throws IOException {
        return Files.readAllLines(Paths.get(filePath)).get(0);
    }
}
```
<h4>Compliant solution</h4>

```java
package myapp.helpers;

import java.io.IOException;
import java.nio.file.*;

public class FileHelper {
    public static String readFirstLine(String filePath) throws IOException {
        return Files.readAllLines(Paths.get(filePath)).get(0);
    }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://docs.oracle.com/javase/tutorial/java/package/usepkgs.html">Java packages</a> </li>
</ul>
<h3>Related rules</h3>
<ul>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S1144'>java:S1144</a> - Unused "private" methods should be removed </li>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S1481'>java:S1481</a> - Unused local variables should be removed </li>
</ul>