<h2>Why is this an issue?</h2>
<p>Using the same value on both sides of a binary operator is a code defect. In the case of logical operators, it is either a copy/paste error and,
therefore, a bug, or it is simply duplicated code and should be simplified. In the case of bitwise operators and most binary mathematical operators,
having the same value on both sides of an operator yields predictable results and should be simplified as well.</p>
<h3>Noncompliant code example</h3>

```java
if ( a == a ) { // always true
  doZ();
}
if ( a != a ) { // always false
  doY();
}
if ( a == b && a == b ) { // if the first one is true, the second one is too
  doX();
}
if ( a == b || a == b ) { // if the first one is true, the second one is too
  doW();
}

int j = 5 / 5; //always 1
int k = 5 - 5; //always 0

c.equals(c); //always true
```
<h3>Exceptions</h3>
<ul>
  <li> This rule ignores <code>*</code>, <code>+</code>, and <code>=</code>. </li>
  <li> The specific case of testing a floating point value against itself is a valid test for <code>NaN</code> and is therefore ignored. </li>
  <li> Similarly, left-shifting 1 onto 1 is common in the construction of bit masks, and is ignored. </li>
</ul>

```java
float f;
if(f != f) { //test for NaN value
  System.out.println("f is NaN");
}

int i = 1 << 1; // Compliant
int j = a << a; // Noncompliant
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/5dUxBQ">CERT, MSC12-C.</a> - Detect and remove code that has no effect or is never executed
  </li>
  <li> <a href='checks/checks/?languages=JAVA&tools=SONAR_LINT&rule=java:S1656'>java:S1656</a> - Implements a check on <code>=</code>. </li>
</ul>