<h2>Why is this an issue?</h2>
<p>Casting expressions are utilized to convert one data type to another, such as transforming an integer into a string. This is especially crucial in
strongly typed languages like C, C++, C#, Java, Python, and others.</p>
<p>However, there are instances where casting expressions are not needed. These include situations like:</p>
<ul>
  <li> casting a variable to its own type </li>
  <li> casting a subclass to a parent class (in the case of polymorphism) </li>
  <li> the programming language is capable of automatically converting the given type to another </li>
</ul>
<p>These scenarios are considered unnecessary casting expressions. They can complicate the code and make it more difficult to understand, without
offering any advantages.</p>
<p>As a result, it’s generally advised to avoid unnecessary casting expressions. Instead, rely on the language’s type system to ensure type safety and
code clarity.</p>
<h3>Exceptions</h3>
<p>Casting may be required to distinguish the method to call in the case of overloading:</p>

```java
class A {}
class B extends A{}
class C {
  void fun(A a){}
  void fun(B b){}

  void foo() {
    B b = new B();
    fun(b);
    fun((A) b); // Compliant, required to call the first method so cast is not redundant.
  }
}
```
<h2>How to fix it</h2>
<p>To fix your code remove the unnecessary casting expression.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
class Example {
    public void example(List<String> list) {
        for (String item: (List<String>) list) {  // Noncompliant, Remove this unnecessary cast to "List".
          //...
        }
    }
}
```
<h4>Compliant solution</h4>

```java
class Example {
    public void example() {
        for (String foo : getFoos()) {
          //...
        }
    }

    public List<String> getFoos() {
        return List.of("foo1", "foo2");
    }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Geeksforgeeks - <a href="https://www.geeksforgeeks.org/type-conversion-java-examples/">Type conversion in Java with Examples</a> </li>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/Type_conversion">Type Conversion</a> </li>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/Strong_and_weak_typing">Strong and Weak Typing</a> </li>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/Polymorphism_(computer_science)"> Polymorphism (Computer Science)</a> </li>
</ul>