<h2>Why is this an issue?</h2>
<p>Nested ternaries are hard to read and can make the order of operations complex to understand.</p>

```java
public String getReadableStatus(Job j) {
  return j.isRunning() ? "Running" : j.hasErrors() ? "Failed" : "Succeeded";  // Noncompliant
}
```
<p>Instead, use another line to express the nested operation in a separate statement.</p>

```java
public String getReadableStatus(Job j) {
  if (j.isRunning()) {
    return "Running";
  }
  return j.hasErrors() ? "Failed" : "Succeeded";
}
```