<h2>Why is this an issue?</h2>
<p>Because Double Brace Initialization (DBI) creates an anonymous class with a reference to the instance of the owning object, its use can lead to
memory leaks if the anonymous inner class is returned and held by other objects. Even when there’s no leak, DBI is so obscure that it’s bound to
confuse most maintainers.</p>
<p>For collections, use <code>Arrays.asList</code> instead, or explicitly add each item directly to the collection.</p>
<h3>Noncompliant code example</h3>

```java
Map source = new HashMap(){{ // Noncompliant
    put("firstName", "John");
    put("lastName", "Smith");
}};
```
<h3>Compliant solution</h3>

```java
Map source = new HashMap();
// ...
source.put("firstName", "John");
source.put("lastName", "Smith");
// ...
```