<h2>Why is this an issue?</h2>
<p>There are two types of stream operations: intermediate operations, which return another stream, and terminal operations, which return something
other than a stream. Intermediate operations are lazy, meaning they aren’t actually executed until and unless a terminal stream operation is performed
on their results. Consequently, if the result of an intermediate stream operation is not fed to a terminal operation, it serves no purpose, which is
almost certainly an error.</p>
<h3>Noncompliant code example</h3>

```java
widgets.stream().filter(b -> b.getColor() == RED); // Noncompliant
```
<h3>Compliant solution</h3>

```java
int sum = widgets.stream()
                      .filter(b -> b.getColor() == RED)
                      .mapToInt(b -> b.getWeight())
                      .sum();
Stream<Widget> pipeline = widgets.stream()
                                 .filter(b -> b.getColor() == GREEN)
                                 .mapToInt(b -> b.getWeight());
sum = pipeline.sum();
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/javase/8/docs/api/java/util/stream/package-summary.html#StreamOps">Stream Operations</a> </li>
</ul>