<h2>Why is this an issue?</h2>
<p>It is very common to pass a collection constructor reference as an argument, for example <code>Collectors.toCollection(ArrayList::new)</code> takes
the <code>ArrayList::new</code> constructor. When the method expects a <code>java.util.function.Supplier</code> it is perfectly fine. However when the
method argument type is <code>java.util.function.Function</code> it means that an argument will be passed to the constructor.</p>
<p>The first argument of Collections constructors is usually an integer representing its "initial capacity". This is generally not what the developer
expects, but the memory allocation is not visible at first glance.</p>
<p>This rule raises an issue when a collection constructor is passed by reference as a <code>java.util.function.Function</code> argument.</p>
<h3>Noncompliant code example</h3>

```java
Arrays.asList(1, 2, 54000).stream().collect(Collectors.toMap(Function.identity(), ArrayList::new)); // Noncompliant, "ArrayList::new" unintentionally refers to "ArrayList(int initialCapacity)" instead of "ArrayList()"
```
<h3>Compliant solution</h3>

```java
Arrays.asList(1, 2, 54000).stream().collect(Collectors.toMap(Function.identity(), id -> new ArrayList<>())); // Compliant, explicitly show the usage of "id -> new ArrayList<>()" or "id -> new ArrayList<>(id)"
```