<h2>Why is this an issue?</h2>
<p>Why use named groups only to never use any of them later on in the code?</p>
<p>This rule raises issues every time named groups are:</p>
<ul>
  <li> defined but never called anywhere in the code through their name; </li>
  <li> defined but called elsewhere in the code by their number instead; </li>
  <li> referenced while not defined. </li>
</ul>
<h3>Noncompliant code example</h3>

```java
String date = "01/02";

Pattern datePattern = Pattern.compile("(?<month>[0-9]{2})/(?<year>[0-9]{2})");
Matcher dateMatcher = datePattern.matcher(date);

if (dateMatcher.matches()) {
  checkValidity(dateMatcher.group(1), dateMatcher.group(2));  // Noncompliant - numbers instead of names of groups are used
  checkValidity(dateMatcher.group("day")); // Noncompliant - there is no group called "day"
}

// ...

String score = "14:1";

Pattern scorePattern = Pattern.compile("(?<player1>[0-9]+):(?<player2>[0-9]+)"); // Noncompliant - named groups are never used
Matcher scoreMatcher = scorePattern.matcher(score);

if (scoreMatcher.matches()) {
  checkScore(score);
}
```
<h3>Compliant solution</h3>

```java
String date = "01/02";

Pattern datePattern = Pattern.compile("(?<month>[0-9]{2})/(?<year>[0-9]{2})");
Matcher dateMatcher = datePattern.matcher(date);

if (dateMatcher.matches()) {
  checkValidity(dateMatcher.group("month"), dateMatcher.group("year"));
}

// ...

String score = "14:1";

Pattern scorePattern = Pattern.compile("(?<player1>[0-9]+):(?<player2>[0-9]+)");
Matcher scoreMatcher = scorePattern.matcher(score);

if (scoreMatcher.matches()) {
  checkScore(scoreMatcher.group("player1"));
  checkScore(scoreMatcher.group("player2"));
}
```
<p>Or, using dedicated variables instead of group names:</p>

```java
String score = "14:1";

String player = "([0-9]+)";
String gameScore = player + ":" + player;

Pattern scorePattern = Pattern.compile(gameScore);
Matcher scoreMatcher = scorePattern.matcher(score);

if (scoreMatcher.matches()) {
  checkScore(score);
}
```