<h2>Why is this an issue?</h2>
<p>In Records, serialization is not done the same way as for ordinary serializable or externalizable classes. The serialized representation of a
record object will be a sequence of values (record components). During the deserialization of records, the stream of components is read and components
are constructed. Then the record object is recreated by invoking the record’s canonical constructor with the component values serving as arguments (or
default values for absent arguments).</p>
<p>This process cannot be customized, so any class-specific <code>writeObject</code>, <code>readObject</code>, <code>readObjectNoData</code>,
<code>writeExternal</code>, and <code>readExternal</code> methods or <code>serialPersistentFields</code> fields in record classes are ignored during
serialization and deserialization.</p>
<p>However, there is a way to substitute serialized/deserialized objects in <code>writeReplace</code> and <code>readResolve</code>.</p>
<p>This rule raises an issue when any of <code>writeObject</code>, <code>readObject</code>, <code>readObjectNoData</code>, <code>writeExternal</code>,
<code>readExternal</code> or <code>serialPersistentFields</code> are present as members in a Record class.</p>
<h3>Noncompliant code example</h3>

```java
record Record() implements Serializable {
  @Serial
  private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0]; // Noncompliant
  @Serial
  private void writeObject(ObjectOutputStream out) throws IOException { // Noncompliant
    ...
  }
}
record Record() implements Externalizable {
  @Override
  public void writeExternal(ObjectOutput out) throws IOException { // Noncompliant
    ...
  }
  @Override
  public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException { // Noncompliant
    ...
  }
}
```
<h3>Compliant solution</h3>

```java
record Record() implements Serializable {}

record Record() implements Serializable {
  private Object writeReplace() throws ObjectStreamException {
    ...
  }
  private Object readResolve() throws ObjectStreamException {
    ...
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/javase/specs/jls/se16/html/jls-8.html#jls-8.10">Records specification</a> </li>
  <li> <a href="https://docs.oracle.com/en/java/javase/16/docs/specs/serialization/serial-arch.html#serialization-of-records">serialization of
  records</a> </li>
</ul>