<h2>Why is this an issue?</h2>
<p>In Java 21 the <code>java.lang.Math</code> class was updated with the static method <code>Math.clamp</code>, to clamp a numerical value between a
min and a max value.</p>
<p>Using this built-in method is now the preferred way to restrict to a given interval, as it is more readable and less error-prone.</p>
<h2>How to fix it</h2>
<p>Replace your clamp method implementation with the <code>Math.clamp</code> method.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```java
int clampedValue = value > max ? max : value < min ? min : value; // Noncompliant; Replace with "Math.clamp"
```

```java
int clampedValue = Math.max(min, Math.min(max, value)); // Noncompliant; Replace with "Math.clamp"
```
<h4>Compliant solution</h4>

```java
int clampedValue = Math.clamp(value, min, max);
```

```java
int clampedValue = Math.clamp(value, min, max);
```