<h2>Why is this an issue?</h2>
<p>Defining functions inside loops in JavaScript can lead to several issues and is generally considered bad practice. The main problems associated
with this approach are related to performance, scope, and potential unintended behavior:</p>
<ul>
  <li> When a function is defined inside a loop, the function is re-created on each iteration of the loop. This can cause unnecessary overhead and
  lead to performance issues, especially if the loop runs repeatedly. Defining the function outside the loop is more efficient so that it is created
  only once. </li>
  <li> Functions defined inside loops have access to the loop’s variables and parameters. This can sometimes lead to unintended behavior or bugs due
  to closures. Closures in JavaScript capture the environment in which they are created, including variables and parameters, and this can cause
  unexpected results when those variables change during the loop. </li>
  <li> Code that defines functions inside loops can be harder to read and maintain, especially for other developers who might not expect functions to
  be redefined within the loop. Keeping functions separate and clearly defined is better, improving code organization and understandability. </li>
</ul>

```js
for (let i = 0; i < 5; i++) {
  function processItem(item) { // Noncompliant: Function 'processItem' inside a for loop
    // Some processing logic
    console.log(item);
  }

  processItem(i);
}
```
<p>Define the function outside the loop and use the function parameters to pass any needed variables instead.</p>

```js
function processItem(item) {
  // Some processing logic
  console.log(item);
}

for (let i = 0; i < 5; i++) {
  processItem(i);
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Closures">Closures</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/Scope">Scope</a> </li>
</ul>