<h2>Why is this an issue?</h2>
<p>Function parameter names should be unique in JavaScript. Unique parameter names ensure that there is no ambiguity in referring to specific
parameters within the function body. If multiple parameters share the same name, it becomes unclear which parameter is being referred to when using
that name within the function.</p>
<p>Unique parameter names improve the readability and maintainability of code. When parameter names are descriptive and distinct, it becomes easier
for other developers (including yourself) to understand the purpose and functionality of the function.</p>
<p>When parameter names are not unique, the later occurrence of a parameter will overwrite the earlier occurrence, potentially leading to unintended
consequences or bugs. This behavior can cause confusion and make the code harder to debug.</p>

```js
function f(a, b, a) { // Noncompliant: The first occurrence of `a` will be overwritten by the later occurrence
  console.log(a, b);
}

f(1, 2, 3);           // Outputs 5
```
<p>In strict mode, JavaScript enforces stricter rules and detects potential issues. Duplicate parameter names are considered a syntax error in strict
mode. By using unique parameter names, you ensure compatibility with strict mode and can benefit from the enhanced error checking and code quality
improvements it provides.</p>

```js
'use strict';

function f(a, b, a) { // Noncompliant: SyntaxError: Duplicate parameter name not allowed in this context
  console.log(a, b);
}

f(1, 2, 3);
```
<p>You should remove the duplicates or rename them while carefully ensuring you are not altering the semantics of your code.</p>

```js
function f(a, b, c) {
  console.log(a, b, c);
}

f(1, 2, 3);
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Guide/Functions">Functions</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/arguments">The arguments object</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode">Strict mode</a> </li>
</ul>