<h2>Why is this an issue?</h2>
<p>Methods that are never executed are dead code and should be removed. Cleaning out dead code decreases the size of the maintained codebase, making
it easier to understand the program and preventing bugs from being introduced.</p>
<p>When using React class components, all non-React lifecycle methods should be called within the scope of the component. If a method is only called
from outside the class, consider using <code>props</code> to interact with the component and re-render if needed, as React encourages data-driven
components.</p>

```js
class Profile extends React.Component {
  render(props) {
    return <h1>{ props.name }</h1>;
  }

  getDefaultName() { // Noncompliant: this method is never used and is a dead code
    return 'John Smith';
  }
}
```
<p>To fix the issue, remove the dead code or call the method from within the component scope.</p>

```js
class Profile extends React.Component {
  render(props) {
    return <h1>{ props.name || getDefaultName() }</h1>;
  }

  getDefaultName() {
    return 'John Smith';
  }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> React Documentation - <a href="https://reactjs.org/docs/components-and-props.html">Components and Props</a> </li>
  <li> React Documentation - <a href="https://legacy.reactjs.org/docs/state-and-lifecycle.html#adding-lifecycle-methods-to-a-class">Adding Lifecycle
  Methods to a Class</a> </li>
</ul>