<h2>Why is this an issue?</h2>
<p>A boolean literal can be represented in two different ways: <code>true</code> or <code>false</code>. They can be combined with logical operators
(<code>!, &amp;&amp;, ||, ==, !=</code>) to produce logical expressions that represent truth values. However, comparing a boolean literal to a
variable or expression that evaluates to a boolean value is unnecessary and can make the code harder to read and understand. The more complex a
boolean expression is, the harder it will be for developers to understand its meaning and expected behavior, and it will favour the introduction of
new bugs.</p>
<h3>Exceptions</h3>
<p>The use of literal booleans in comparisons which use identity operators (<code>===</code> and <code>!==</code>) are ignored.</p>
<h2>How to fix it</h2>
<p>Remove redundant boolean literals from expressions to improve readability and make the code more maintainable.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```php
if ($booleanVariable == true) { /* ... */ }
if ($booleanVariable != true) { /* ... */ }
if ($booleanVariable || false) { /* ... */ }
doSomething(!false);
```
<h4>Compliant solution</h4>

```php
if ($booleanVariable) { /* ... */ }
if (!$booleanVariable) { /* ... */ }
if ($booleanVariable) { /* ... */ }
doSomething(true);
```